/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.energycell.EnergyCellTileRenderer;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import com.supermartijn642.wormhole.generator.CoalGeneratorScreen;
import com.supermartijn642.wormhole.generator.GeneratorTile;
import com.supermartijn642.wormhole.portal.screen.PortalOverviewScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetColorScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetScreen;
import com.supermartijn642.wormhole.targetcell.TargetCellTileRenderer;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent e) {
        ItemBlockRenderTypes.setRenderLayer((Block)Wormhole.portal, (RenderType)RenderType.m_110466_());
        BlockEntityRenderers.m_173590_(Wormhole.basic_energy_cell_tile, context -> new EnergyCellTileRenderer());
        BlockEntityRenderers.m_173590_(Wormhole.advanced_energy_cell_tile, context -> new EnergyCellTileRenderer());
        BlockEntityRenderers.m_173590_(Wormhole.basic_target_cell_tile, context -> new TargetCellTileRenderer());
        BlockEntityRenderers.m_173590_(Wormhole.advanced_target_cell_tile, context -> new TargetCellTileRenderer());
        ClientProxy.registerScreen();
    }

    @SubscribeEvent
    public static void modelRegistry(ModelRegistryEvent e) {
        for (ResourceLocation model : EnergyCellTileRenderer.ENERGY_CELL_MODELS) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)model);
        }
        for (ResourceLocation model : TargetCellTileRenderer.BASIC_TARGET_CELL_MODELS) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)model);
        }
        for (ResourceLocation model : TargetCellTileRenderer.ADVANCED_TARGET_CELL_MODELS) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)model);
        }
    }

    public static void registerScreen() {
        MenuScreens.m_96206_(Wormhole.coal_generator_container, (container, player, title) -> new CoalGeneratorScreen((CoalGeneratorContainer)container, player));
    }

    public static void openTargetDeviceScreen(InteractionHand hand, BlockPos pos, float yaw) {
        Minecraft.m_91087_().m_91152_((Screen)new TargetDeviceScreen(ClientProxy.getPlayer(), hand, pos, yaw));
    }

    public static void openPortalTargetScreen(BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new PortalTargetScreen(pos, ClientProxy.getPlayer()));
    }

    public static void openPortalTargetScreen(BlockPos pos, int scrollOffset, int selectedPortalTarget, int selectedDeviceTarget) {
        Minecraft.m_91087_().m_91152_((Screen)new PortalTargetScreen(pos, ClientProxy.getPlayer(), scrollOffset, selectedPortalTarget, selectedDeviceTarget));
    }

    public static void openPortalTargetColorScreen(BlockPos pos, int targetIndex, Runnable returnScreen) {
        Minecraft.m_91087_().m_91152_((Screen)new PortalTargetColorScreen(pos, targetIndex, returnScreen));
    }

    public static void openPortalOverviewScreen(BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new PortalOverviewScreen(pos));
    }

    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Level getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawSelectionEvent.HighlightBlock e) {
            Level world = ClientProxy.getWorld();
            BlockEntity tile = world.m_7702_(e.getTarget().m_82425_());
            if (tile instanceof GeneratorTile) {
                VoxelShape shape;
                PoseStack matrixStack = e.getPoseStack();
                matrixStack.m_85836_();
                Vec3 playerPos = Minecraft.m_91087_().f_91074_.m_20299_(e.getPartialTicks());
                matrixStack.m_85837_(-playerPos.f_82479_, -playerPos.f_82480_, -playerPos.f_82481_);
                VertexConsumer builder = e.getMultiBufferSource().m_6299_(RenderType.m_110504_());
                for (BlockPos pos : ((GeneratorTile)tile).getChargingPortalBlocks()) {
                    shape = world.m_8055_(pos).m_60816_((BlockGetter)world, pos);
                    Events.drawShape(e.getPoseStack(), builder, shape, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 0.25882354f, 0.42352942f, 0.9607843f, 1.0f);
                }
                for (BlockPos pos : ((GeneratorTile)tile).getChargingEnergyBlocks()) {
                    shape = world.m_8055_(pos).m_60816_((BlockGetter)world, pos);
                    Events.drawShape(e.getPoseStack(), builder, shape, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 0.9490196f, 0.13333334f, 0.13333334f, 1.0f);
                }
                matrixStack.m_85849_();
            }
        }

        private static void drawShape(PoseStack matrixStackIn, VertexConsumer bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
            shapeIn.m_83224_((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
                bufferIn.m_85982_(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).m_85950_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                bufferIn.m_85982_(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).m_85950_(red, green, blue, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            });
        }
    }
}

