/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import java.text.NumberFormat;
import java.util.Locale;

public class EnergyFormat {
    private static EnergyType type = EnergyType.RF;

    public static void cycleEnergyType(boolean forward) {
        type = EnergyType.values()[(type.ordinal() + (forward ? 1 : EnergyType.values().length - 1)) % EnergyType.values().length];
    }

    public static String formatEnergy(int energy) {
        return type.convertEnergy(energy) + " " + EnergyFormat.type.unit;
    }

    public static String formatEnergyPerTick(int energy) {
        return type.convertEnergy(energy) + " " + EnergyFormat.type.unit + "/t";
    }

    public static String formatCapacity(int energy, int capacity) {
        return type.convertEnergy(energy) + " / " + type.convertEnergy(capacity) + " " + EnergyFormat.type.unit;
    }

    private static enum EnergyType {
        RF("RF"),
        FE("FE");

        private final String unit;

        private EnergyType(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public String convertEnergy(int energy) {
            return NumberFormat.getNumberInstance(Locale.getDefault()).format(energy);
        }
    }
}

