/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.google.gson.JsonObject;
import com.supermartijn642.wormhole.Wormhole;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class NBTRecipe
extends ShapedRecipe {
    public static final List<Item> VALID_ITEMS = new LinkedList<Item>();

    public NBTRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        CompoundTag compound = null;
        block0: for (int i = 0; i < inv.m_39346_(); ++i) {
            for (int j = 0; j < inv.m_39347_(); ++j) {
                ItemStack stack = inv.m_8020_(i * inv.m_39347_() + j);
                if (!stack.m_41782_() || !VALID_ITEMS.contains(stack.m_41720_())) continue;
                compound = stack.m_41783_();
                break block0;
            }
        }
        if (compound != null) {
            ItemStack result = this.m_8043_().m_41777_();
            result.m_41784_().m_128391_(compound);
            return result;
        }
        return this.m_8043_().m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return super.m_7707_();
    }

    static {
        VALID_ITEMS.add(Wormhole.target_device);
        VALID_ITEMS.add(Wormhole.advanced_target_device);
        VALID_ITEMS.add(Item.m_41439_((Block)Wormhole.portal_stabilizer));
        VALID_ITEMS.add(Item.m_41439_((Block)Wormhole.basic_energy_cell));
        VALID_ITEMS.add(Item.m_41439_((Block)Wormhole.advanced_energy_cell));
        VALID_ITEMS.add(Item.m_41439_((Block)Wormhole.basic_target_cell));
        VALID_ITEMS.add(Item.m_41439_((Block)Wormhole.advanced_target_cell));
        VALID_ITEMS.add(Item.m_41439_((Block)Wormhole.coal_generator));
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<NBTRecipe> {
        public NBTRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json);
            return new NBTRecipe(recipeId, recipe.m_6076_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_());
        }

        @Nullable
        public NBTRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer);
            return new NBTRecipe(recipeId, recipe.m_6076_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_());
        }

        public void toNetwork(FriendlyByteBuf buffer, NBTRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
        }
    }
}

