/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.PortalTile;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PortalBlock
extends PortalGroupBlock {
    private static final VoxelShape SHAPE_X = Shapes.m_83048_((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_Y = Shapes.m_83048_((double)0.0, (double)0.375, (double)0.0, (double)1.0, (double)0.625, (double)1.0);
    private static final VoxelShape SHAPE_Z = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
    public static final EnumProperty<Direction.Axis> AXIS_PROPERTY = EnumProperty.m_61598_((String)"axis", Direction.Axis.class, (Enum[])Direction.Axis.values());
    public static final EnumProperty<DyeColor> COLOR_PROPERTY = EnumProperty.m_61598_((String)"color", DyeColor.class, (Enum[])DyeColor.values());

    public PortalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76298_).m_60910_().m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60953_(o -> 11).m_60993_(), "portal", PortalTile::new);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS_PROPERTY, (Comparable)Direction.Axis.X)).m_61124_(COLOR_PROPERTY, (Comparable)DyeColor.WHITE));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof PortalTile) {
            return ((PortalTile)tile).activate(player, handIn) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof PortalTile) {
            ((PortalTile)tile).teleport(entityIn);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS_PROPERTY, COLOR_PROPERTY});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS_PROPERTY);
        return axis == Direction.Axis.X ? SHAPE_X : (axis == Direction.Axis.Y ? SHAPE_Y : (axis == Direction.Axis.Z ? SHAPE_Z : Shapes.m_83040_()));
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof PortalTile && !((PortalTile)tile).hasGroup()) {
            tile.m_58904_().m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }
}

