/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.packet.UpdateGroupPacket;
import com.supermartijn642.wormhole.packet.UpdateGroupsPacket;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import com.supermartijn642.wormhole.portal.PortalShape;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PortalGroupCapability {
    public static Capability<PortalGroupCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PortalGroupCapability>(){});
    private final Level world;
    private final List<PortalGroup> groups = new LinkedList<PortalGroup>();
    private final Map<BlockPos, PortalGroup> groupsByPosition = new HashMap<BlockPos, PortalGroup>();

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent e) {
        e.register(PortalGroupCapability.class);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Level> e) {
        Level world = (Level)e.getObject();
        final LazyOptional capability = LazyOptional.of(() -> new PortalGroupCapability(world));
        e.addCapability(new ResourceLocation("wormhole", "portal_groups"), (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CAPABILITY ? capability.cast() : LazyOptional.empty();
            }

            public Tag serializeNBT() {
                return capability.map(PortalGroupCapability::write).orElse(null);
            }

            public void deserializeNBT(Tag nbt) {
                capability.ifPresent(portalGroupCapability -> portalGroupCapability.read(nbt));
            }
        });
        e.addListener(() -> ((LazyOptional)capability).invalidate());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        PortalGroupCapability.tickWorldCapability(e.world);
    }

    public static void tickWorldCapability(Level world) {
        world.getCapability(CAPABILITY).ifPresent(PortalGroupCapability::tick);
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerChangedDimensionEvent e) {
        ServerPlayer player = (ServerPlayer)e.getPlayer();
        player.f_19853_.getCapability(CAPABILITY).ifPresent(groups -> Wormhole.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateGroupsPacket(groups.write())));
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        ServerPlayer player = (ServerPlayer)e.getPlayer();
        player.f_19853_.getCapability(CAPABILITY).ifPresent(groups -> Wormhole.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateGroupsPacket(groups.write())));
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ServerPlayer player = (ServerPlayer)e.getPlayer();
        player.f_19853_.getCapability(CAPABILITY).ifPresent(groups -> Wormhole.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateGroupsPacket(groups.write())));
    }

    public PortalGroupCapability(Level world) {
        this.world = world;
    }

    public PortalGroupCapability() {
        this.world = null;
    }

    public void add(PortalShape shape) {
        PortalGroup group = new PortalGroup(this.world, shape);
        this.groups.add(group);
        group.shape.frame.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
        group.shape.area.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
        this.update();
    }

    public void remove(PortalGroup group) {
        this.groups.remove(group);
        group.shape.frame.forEach(this.groupsByPosition::remove);
        group.shape.area.forEach(this.groupsByPosition::remove);
        this.update();
    }

    public void tick() {
        for (PortalGroup group : this.groupsByPosition.values()) {
            group.canTick = true;
        }
    }

    public void updateGroup(PortalGroup group) {
        if (!this.world.f_46443_ && group != null) {
            Wormhole.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((Level)this.world).m_46472_()), (Object)new UpdateGroupPacket(this.writeGroup(group)));
        }
    }

    private void update() {
        Wormhole.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((Level)this.world).m_46472_()), (Object)new UpdateGroupsPacket(this.write()));
    }

    public PortalGroup getGroup(PortalGroupTile tile) {
        return this.groupsByPosition.get(tile.m_58899_());
    }

    public PortalGroup getGroup(BlockPos pos) {
        return this.groupsByPosition.get(pos);
    }

    public Collection<PortalGroup> getGroups() {
        return this.groupsByPosition.values();
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        CompoundTag groupsTag = new CompoundTag();
        for (int i = 0; i < this.groups.size(); ++i) {
            groupsTag.m_128365_("groups" + i, (Tag)this.groups.get(i).write());
        }
        compound.m_128365_("groups", (Tag)groupsTag);
        return compound;
    }

    public void read(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            this.groups.clear();
            this.groupsByPosition.clear();
            CompoundTag groupsTag = compound.m_128469_("groups");
            for (String key : groupsTag.m_128431_()) {
                PortalGroup group = new PortalGroup(this.world, groupsTag.m_128469_(key));
                this.groups.add(group);
                group.shape.frame.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
                group.shape.area.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
            }
        }
    }

    private CompoundTag writeGroup(PortalGroup group) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("group", (Tag)group.write());
        return tag;
    }

    public void readGroup(CompoundTag tag) {
        if (tag.m_128441_("group")) {
            PortalGroup group = new PortalGroup(this.world, tag.m_128469_("group"));
            this.groups.add(group);
            group.shape.frame.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
            group.shape.area.forEach(pos -> this.groupsByPosition.put((BlockPos)pos, group));
        }
    }
}

