/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.EnergyFormat;
import com.supermartijn642.wormhole.StabilizerTile;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class StabilizerBlock
extends PortalGroupBlock {
    public static final BooleanProperty ON_PROPERTY = BooleanProperty.m_61465_((String)"on");

    public StabilizerBlock() {
        super("portal_stabilizer", StabilizerTile::new);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ON_PROPERTY, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof StabilizerTile) {
            return ((StabilizerTile)tile).activate(player) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON_PROPERTY});
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("wormhole.portal_stabilizer.info").m_130940_(ChatFormatting.AQUA));
        CompoundTag tag = stack.m_41784_().m_128441_("tileData") ? stack.m_41784_().m_128469_("tileData") : null;
        int targets = tag == null || tag.m_128456_() || !tag.m_128441_("targetCount") ? 0 : tag.m_128451_("targetCount");
        int targetCapacity = WormholeConfig.stabilizerTargetCapacity.get();
        if (targetCapacity > 0) {
            tooltip.add((Component)new TranslatableComponent("wormhole.portal_stabilizer.info.targets", new Object[]{targets, targetCapacity}).m_130940_(ChatFormatting.YELLOW));
        }
        int energy = tag == null || tag.m_128456_() || !tag.m_128441_("energy") ? 0 : tag.m_128451_("energy");
        int energyCapacity = WormholeConfig.stabilizerEnergyCapacity.get();
        if (energyCapacity > 0) {
            tooltip.add((Component)new TextComponent(EnergyFormat.formatCapacity(energy, energyCapacity)).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

