/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.NBTRecipe;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.PortalTile;
import com.supermartijn642.wormhole.StabilizerBlock;
import com.supermartijn642.wormhole.StabilizerTile;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellTile;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import com.supermartijn642.wormhole.generator.CoalGeneratorTile;
import com.supermartijn642.wormhole.packet.PortalGroupPacket;
import com.supermartijn642.wormhole.packet.TargetDevicePacket;
import com.supermartijn642.wormhole.packet.UpdateGroupPacket;
import com.supermartijn642.wormhole.packet.UpdateGroupsPacket;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import com.supermartijn642.wormhole.portal.packets.PortalActivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalAddTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalClearTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalColorTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalDeactivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalMoveTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalNameTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalSelectTargetPacket;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellTile;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceAddPacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceMovePacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceNamePacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceRemovePacket;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="wormhole")
public class Wormhole {
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("wormhole", "main"), () -> "1", "1"::equals, "1"::equals);
    public static final RecipeSerializer<NBTRecipe> NBT_RECIPE_SERIALIZER = new NBTRecipe.Serializer();
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("wormhole"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)advanced_target_device);
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            items.sort(Comparator.comparing(a -> a.m_41786_().getString()));
        }
    };
    @ObjectHolder(value="wormhole:portal_frame")
    public static Block portal_frame;
    @ObjectHolder(value="wormhole:portal")
    public static Block portal;
    @ObjectHolder(value="wormhole:portal_stabilizer")
    public static Block portal_stabilizer;
    @ObjectHolder(value="wormhole:basic_energy_cell")
    public static EnergyCellBlock basic_energy_cell;
    @ObjectHolder(value="wormhole:advanced_energy_cell")
    public static EnergyCellBlock advanced_energy_cell;
    @ObjectHolder(value="wormhole:creative_energy_cell")
    public static EnergyCellBlock creative_energy_cell;
    @ObjectHolder(value="wormhole:target_device")
    public static Item target_device;
    @ObjectHolder(value="wormhole:advanced_target_device")
    public static Item advanced_target_device;
    @ObjectHolder(value="wormhole:basic_target_cell")
    public static TargetCellBlock basic_target_cell;
    @ObjectHolder(value="wormhole:advanced_target_cell")
    public static TargetCellBlock advanced_target_cell;
    @ObjectHolder(value="wormhole:coal_generator")
    public static CoalGeneratorBlock coal_generator;
    @ObjectHolder(value="wormhole:portal_frame_tile")
    public static BlockEntityType<?> portal_frame_tile;
    @ObjectHolder(value="wormhole:portal_tile")
    public static BlockEntityType<?> portal_tile;
    @ObjectHolder(value="wormhole:stabilizer_tile")
    public static BlockEntityType<?> stabilizer_tile;
    @ObjectHolder(value="wormhole:basic_energy_cell_tile")
    public static BlockEntityType<EnergyCellTile> basic_energy_cell_tile;
    @ObjectHolder(value="wormhole:advanced_energy_cell_tile")
    public static BlockEntityType<EnergyCellTile> advanced_energy_cell_tile;
    @ObjectHolder(value="wormhole:creative_energy_cell_tile")
    public static BlockEntityType<EnergyCellTile> creative_energy_cell_tile;
    @ObjectHolder(value="wormhole:basic_target_cell_tile")
    public static BlockEntityType<TargetCellTile> basic_target_cell_tile;
    @ObjectHolder(value="wormhole:advanced_target_cell_tile")
    public static BlockEntityType<TargetCellTile> advanced_target_cell_tile;
    @ObjectHolder(value="wormhole:coal_generator_tile")
    public static BlockEntityType<CoalGeneratorTile> coal_generator_tile;
    @ObjectHolder(value="wormhole:coal_generator_container")
    public static MenuType<CoalGeneratorContainer> coal_generator_container;

    public Wormhole() {
        CHANNEL.registerMessage(0, TargetDeviceAddPacket.class, TargetDeviceAddPacket::encode, TargetDeviceAddPacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(1, TargetDeviceMovePacket.class, TargetDeviceMovePacket::encode, TargetDeviceMovePacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(2, TargetDeviceRemovePacket.class, TargetDeviceRemovePacket::encode, TargetDeviceRemovePacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(3, TargetDeviceNamePacket.class, TargetDeviceNamePacket::encode, TargetDeviceNamePacket::new, TargetDevicePacket::handle);
        CHANNEL.registerMessage(4, PortalAddTargetPacket.class, PortalAddTargetPacket::encode, PortalAddTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(5, PortalClearTargetPacket.class, PortalClearTargetPacket::encode, PortalClearTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(6, PortalMoveTargetPacket.class, PortalMoveTargetPacket::encode, PortalMoveTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(7, PortalNameTargetPacket.class, PortalNameTargetPacket::encode, PortalNameTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(8, PortalSelectTargetPacket.class, PortalSelectTargetPacket::encode, PortalSelectTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(9, UpdateGroupPacket.class, UpdateGroupPacket::encode, UpdateGroupPacket::new, UpdateGroupPacket::handle);
        CHANNEL.registerMessage(10, UpdateGroupsPacket.class, UpdateGroupsPacket::encode, UpdateGroupsPacket::new, UpdateGroupsPacket::handle);
        CHANNEL.registerMessage(11, PortalColorTargetPacket.class, PortalColorTargetPacket::encode, PortalColorTargetPacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(12, PortalActivatePacket.class, PortalGroupPacket::encode, PortalActivatePacket::new, PortalGroupPacket::handle);
        CHANNEL.registerMessage(13, PortalDeactivatePacket.class, PortalGroupPacket::encode, PortalDeactivatePacket::new, PortalGroupPacket::handle);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            e.getRegistry().register((IForgeRegistryEntry)new PortalGroupBlock("portal_frame", (pos, state) -> new PortalGroupTile(portal_frame_tile, (BlockPos)pos, (BlockState)state)));
            e.getRegistry().register((IForgeRegistryEntry)new PortalBlock());
            e.getRegistry().register((IForgeRegistryEntry)new StabilizerBlock());
            for (EnergyCellType energyCellType : EnergyCellType.values()) {
                e.getRegistry().register((IForgeRegistryEntry)new EnergyCellBlock(energyCellType));
            }
            for (Enum enum_ : TargetCellType.values()) {
                e.getRegistry().register((IForgeRegistryEntry)new TargetCellBlock((TargetCellType)enum_));
            }
            e.getRegistry().register((IForgeRegistryEntry)new CoalGeneratorBlock());
        }

        @SubscribeEvent
        public static void onTileRegistry(RegistryEvent.Register<BlockEntityType<?>> e) {
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_((pos, state) -> new PortalGroupTile(portal_frame_tile, pos, state), (Block[])new Block[]{portal_frame}).m_58966_(null).setRegistryName("portal_frame_tile")));
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(PortalTile::new, (Block[])new Block[]{portal}).m_58966_(null).setRegistryName("portal_tile")));
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(StabilizerTile::new, (Block[])new Block[]{portal_stabilizer}).m_58966_(null).setRegistryName("stabilizer_tile")));
            for (EnergyCellType energyCellType : EnergyCellType.values()) {
                e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(energyCellType::createTile, (Block[])new Block[]{energyCellType.getBlock()}).m_58966_(null).setRegistryName(energyCellType.getRegistryName() + "_tile")));
            }
            for (Enum enum_ : TargetCellType.values()) {
                e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(((TargetCellType)enum_)::createTile, (Block[])new Block[]{((TargetCellType)enum_).getBlock()}).m_58966_(null).setRegistryName(((TargetCellType)enum_).getRegistryName() + "_tile")));
            }
            e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(CoalGeneratorTile::new, (Block[])new Block[]{coal_generator}).m_58966_(null).setRegistryName("coal_generator_tile")));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(portal_frame, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(portal_frame.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(portal, new Item.Properties()).setRegistryName(portal.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(portal_stabilizer, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(portal_stabilizer.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)basic_energy_cell, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(basic_energy_cell.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)advanced_energy_cell, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(advanced_energy_cell.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)creative_energy_cell, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(creative_energy_cell.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)basic_target_cell, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(basic_target_cell.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)advanced_target_cell, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(advanced_target_cell.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)coal_generator, new Item.Properties().m_41491_(ITEM_GROUP)).setRegistryName(coal_generator.getRegistryName())));
            e.getRegistry().register((IForgeRegistryEntry)new TargetDeviceItem("target_device", WormholeConfig.basicDeviceTargetCount::get));
            e.getRegistry().register((IForgeRegistryEntry)new TargetDeviceItem("advanced_target_device", WormholeConfig.advancedDeviceTargetCount::get));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<MenuType<?>> e) {
            e.getRegistry().register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, inv, data) -> new CoalGeneratorContainer(windowId, inv.f_35978_, data.m_130135_())).setRegistryName("coal_generator_container")));
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<RecipeSerializer<?>> e) {
            e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)NBT_RECIPE_SERIALIZER.setRegistryName(new ResourceLocation("wormhole", "nbtrecipe"))));
        }
    }
}

