/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.WormholeTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;

public class WormholeBlock
extends Block {
    private final boolean saveTileData;

    public WormholeBlock(String registryName, boolean saveTileData, BlockBehaviour.Properties properties) {
        super(properties);
        this.setRegistryName(registryName);
        this.saveTileData = saveTileData;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!this.saveTileData) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        CompoundTag compoundTag = tag == null ? null : (tag = tag.m_128441_("tileData") ? tag.m_128469_("tileData") : null);
        if (tag == null || tag.m_128456_()) {
            return;
        }
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof WormholeTile) {
            ((WormholeTile)tile).readData(tag);
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List items = super.m_7381_(state, builder);
        if (!this.saveTileData) {
            return items;
        }
        BlockEntity tile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (!(tile instanceof WormholeTile)) {
            return items;
        }
        CompoundTag tileTag = ((WormholeTile)tile).writeData();
        if (tileTag == null || tileTag.m_128456_()) {
            return items;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("tileData", (Tag)tileTag);
        for (ItemStack stack : items) {
            if (!(stack.m_41720_() instanceof BlockItem) || ((BlockItem)stack.m_41720_()).m_40614_() != this) continue;
            stack.m_41751_(tag);
        }
        return items;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        if (!this.saveTileData) {
            return stack;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof WormholeTile)) {
            return stack;
        }
        CompoundTag tileTag = ((WormholeTile)tile).writeData();
        if (tileTag == null || tileTag.m_128456_()) {
            return stack;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("tileData", (Tag)tileTag);
        if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() == this) {
            stack.m_41751_(tag);
        }
        return stack;
    }
}

