/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.portal.IEnergyCellTile;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCellTile
extends PortalGroupTile
implements IEnergyCellTile {
    protected final EnergyCellType f_58855_;
    protected int energy = 0;

    public EnergyCellTile(EnergyCellType type, BlockPos pos, BlockState state) {
        super(type.getTileEntityType(), pos, state);
        this.f_58855_ = type;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().receiveEnergy(maxReceive, simulate);
        }
        if (maxReceive < 0) {
            return -this.extractEnergy(-maxReceive, simulate);
        }
        int absorb = Math.min(this.getMaxEnergyStored(true) - this.energy, maxReceive);
        if (!simulate) {
            this.energy += absorb;
            if (absorb > 0) {
                this.dataChanged();
            }
        }
        return absorb;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
        if (maxExtract < 0) {
            return -this.receiveEnergy(-maxExtract, simulate);
        }
        int drain = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= drain;
            if (drain > 0) {
                this.dataChanged();
            }
        }
        return drain;
    }

    @Override
    public int getEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getStoredEnergy();
        }
        return Math.min(this.energy, this.getMaxEnergyStored(true));
    }

    @Override
    public int getMaxEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getEnergyCapacity();
        }
        return this.f_58855_.getCapacity();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag tag = super.writeData();
        tag.m_128405_("energy", this.energy);
        return tag;
    }

    @Override
    protected void readData(CompoundTag tag) {
        super.readData(tag);
        this.energy = tag.m_128441_("energy") ? tag.m_128451_("energy") : 0;
    }

    public static class CreativeEnergyCellTile
    extends EnergyCellTile {
        public CreativeEnergyCellTile(BlockPos pos, BlockState state) {
            super(EnergyCellType.CREATIVE, pos, state);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
            return 0;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
            return maxExtract;
        }

        @Override
        public int getEnergyStored(boolean fromGroup) {
            return this.getMaxEnergyStored();
        }

        @Override
        public int getMaxEnergyStored(boolean fromGroup) {
            return this.f_58855_.getCapacity();
        }

        @Override
        public boolean canExtract() {
            return true;
        }

        @Override
        public void tick() {
            super.tick();
            for (Direction direction : Direction.values()) {
                BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
                if (tile == null) continue;
                tile.getCapability(CapabilityEnergy.ENERGY).ifPresent(this::pushEnergy);
            }
        }

        public void pushEnergy(IEnergyStorage energyStorage) {
            if (energyStorage.canReceive()) {
                energyStorage.receiveEnergy(this.getMaxEnergyStored(true), false);
            }
        }
    }

    public static class AdvancedEnergyCellTile
    extends EnergyCellTile {
        public AdvancedEnergyCellTile(BlockPos pos, BlockState state) {
            super(EnergyCellType.ADVANCED, pos, state);
        }
    }

    public static class BasicEnergyCellTile
    extends EnergyCellTile {
        public BasicEnergyCellTile(BlockPos pos, BlockState state) {
            super(EnergyCellType.BASIC, pos, state);
        }
    }
}

