/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.wormhole.energycell.EnergyCellTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class EnergyCellTileRenderer
implements BlockEntityRenderer<EnergyCellTile> {
    public static final ResourceLocation[] ENERGY_CELL_MODELS = new ResourceLocation[16];

    public void render(EnergyCellTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int texture = tile.getMaxEnergyStored(true) > 0 ? (int)Math.ceil((double)tile.getEnergyStored(true) / (double)tile.getMaxEnergyStored(true) * 15.0) : 0;
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(ENERGY_CELL_MODELS[texture]);
        ClientUtils.getBlockRenderer().m_110937_().renderModel(matrixStack.m_85850_(), buffer.m_6299_(RenderType.m_110451_()), tile.m_58900_(), model, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
    }

    public static BakedModel getModelForTile(EnergyCellTile tile) {
        int texture = tile.getMaxEnergyStored(true) > 0 ? (int)Math.ceil((double)tile.getEnergyStored(true) / (double)tile.getMaxEnergyStored(true) * 15.0) : 0;
        return Minecraft.m_91087_().m_91304_().getModel(ENERGY_CELL_MODELS[texture]);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            EnergyCellTileRenderer.ENERGY_CELL_MODELS[i] = new ResourceLocation("wormhole", "block/energy_cell/basic/basic_energy_cell_" + i);
        }
    }
}

