/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.wormhole.EnergyFormat;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeBlock;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import com.supermartijn642.wormhole.generator.CoalGeneratorTile;
import com.supermartijn642.wormhole.generator.GeneratorTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class CoalGeneratorBlock
extends WormholeBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.0625, (double)0.875, (double)0.75, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.8125, (double)0.4375, (double)0.4375, (double)0.9375), Shapes.m_83048_((double)0.25, (double)0.4375, (double)0.8125, (double)0.375, (double)0.625, (double)0.875), Shapes.m_83048_((double)0.5625, (double)0.0, (double)0.8125, (double)0.8125, (double)0.4375, (double)0.9375), Shapes.m_83048_((double)0.625, (double)0.4375, (double)0.8125, (double)0.75, (double)0.625, (double)0.875)});
    private static final VoxelShape[] SHAPES = new VoxelShape[4];
    public static final BooleanProperty LIT;
    public static final EnumProperty<Direction> FACING;

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public CoalGeneratorBlock() {
        super("coal_generator", true, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60918_(SoundType.f_56743_).m_60999_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, final BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return null;
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new CoalGeneratorContainer(windowId, player, pos);
                }
            }, (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int range = 2 * WormholeConfig.coalGeneratorRange.get() + 1;
        tooltip.add((Component)new TranslatableComponent("wormhole.coal_generator.info", new Object[]{range, EnergyFormat.formatEnergyPerTick(WormholeConfig.coalGeneratorPower.get())}).m_130940_(ChatFormatting.AQUA));
        CompoundTag tag = stack.m_41784_().m_128441_("tileData") ? stack.m_41784_().m_128469_("tileData") : null;
        int energy = tag == null || tag.m_128456_() || !tag.m_128441_("energy") ? 0 : tag.m_128451_("energy");
        tooltip.add((Component)new TextComponent(EnergyFormat.formatCapacity(energy, WormholeConfig.coalGeneratorCapacity.get())).m_130940_(ChatFormatting.YELLOW));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_(FACING)).m_122416_()];
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 8 : 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CoalGeneratorTile(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == Wormhole.coal_generator_tile ? (world2, pos, state2, entity) -> ((GeneratorTile)entity).tick() : null;
    }

    static {
        CoalGeneratorBlock.SHAPES[Direction.NORTH.m_122416_()] = SHAPE;
        CoalGeneratorBlock.SHAPES[Direction.EAST.m_122416_()] = CoalGeneratorBlock.rotateShape(Direction.NORTH, Direction.EAST, SHAPE);
        CoalGeneratorBlock.SHAPES[Direction.SOUTH.m_122416_()] = CoalGeneratorBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE);
        CoalGeneratorBlock.SHAPES[Direction.WEST.m_122416_()] = CoalGeneratorBlock.rotateShape(Direction.NORTH, Direction.WEST, SHAPE);
        LIT = BooleanProperty.m_61465_((String)"lit");
        FACING = HorizontalDirectionalBlock.f_54117_;
    }
}

