/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.packet;

import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.portal.PortalGroup;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public abstract class PortalGroupPacket {
    protected BlockPos pos;

    public PortalGroupPacket(PortalGroup group) {
        this.pos = group.shape.frame.get(0);
    }

    public PortalGroupPacket(FriendlyByteBuf buffer) {
        this.decode(buffer);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
    }

    protected void decode(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        ServerPlayer player = contextSupplier.get().getSender();
        if (player == null || player.m_20182_().m_82531_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_()) > 10000.0) {
            return;
        }
        Level world = player.f_19853_;
        if (world == null) {
            return;
        }
        PortalGroupCapability groups = (PortalGroupCapability)world.getCapability(PortalGroupCapability.CAPABILITY).orElse(null);
        if (groups == null) {
            return;
        }
        PortalGroup group = groups.getGroup(this.pos);
        if (group == null) {
            return;
        }
        contextSupplier.get().enqueueWork(() -> this.lambda$handle$0((Player)player, world, group));
    }

    protected abstract void handle(Player var1, Level var2, PortalGroup var3);

    private /* synthetic */ void lambda$handle$0(Player player, Level world, PortalGroup group) {
        this.handle(player, world, group);
    }
}

