/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.google.common.collect.Lists;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.StabilizerTile;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellTile;
import com.supermartijn642.wormhole.portal.IPortalGroupTile;
import com.supermartijn642.wormhole.portal.ITargetCellTile;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PortalShape {
    public static final Map<Direction.Axis, List<BlockPos>> DIRECT_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    private static final Map<Direction.Axis, List<BlockPos>> INDIRECT_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    private static final Map<Direction.Axis, List<BlockPos>> ALL_OFFSETS = new EnumMap<Direction.Axis, List<BlockPos>>(Direction.Axis.class);
    public final Direction.Axis axis;
    public final List<BlockPos> area = new ArrayList<BlockPos>();
    public final List<BlockPos> frame = new ArrayList<BlockPos>();
    public final List<BlockPos> stabilizers = new ArrayList<BlockPos>();
    public final List<BlockPos> energyCells = new ArrayList<BlockPos>();
    public final List<BlockPos> targetCells = new ArrayList<BlockPos>();
    public final double span;
    public final BlockPos minCorner;
    public final BlockPos maxCorner;

    public static PortalShape find(BlockGetter world, BlockPos center) {
        for (Direction.Axis axis : Direction.Axis.values()) {
            PortalShape shape = PortalShape.find(world, center, axis);
            if (shape == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape find(BlockGetter world, BlockPos center, Direction.Axis axis) {
        for (BlockPos offset : ALL_OFFSETS.get(axis)) {
            PortalShape shape;
            if (world.m_8055_(center.m_141952_((Vec3i)offset)).m_60734_() != Blocks.f_50016_ || (shape = PortalShape.findArea(world, center.m_141952_((Vec3i)offset), axis)) == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape findArea(BlockGetter world, BlockPos start, Direction.Axis axis) {
        LinkedList<BlockPos> next = new LinkedList<BlockPos>();
        LinkedList<BlockPos> current = new LinkedList<BlockPos>();
        current.add(start);
        ArrayList<BlockPos> done = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        ArrayList<BlockPos> corners = new ArrayList<BlockPos>();
        ArrayList<BlockPos> stabilizers = new ArrayList<BlockPos>();
        ArrayList<BlockPos> energyCells = new ArrayList<BlockPos>();
        ArrayList<BlockPos> targetCells = new ArrayList<BlockPos>();
        while (!current.isEmpty()) {
            for (BlockPos pos : current) {
                int frames = 0;
                for (BlockPos offset : DIRECT_OFFSETS.get(axis)) {
                    BlockPos offPos = pos.m_141952_((Vec3i)offset);
                    Block block = world.m_8055_(offPos).m_60734_();
                    BlockEntity tile = world.m_7702_(offPos);
                    if (block == Blocks.f_50016_) {
                        if (done.contains(offPos) || current.contains(offPos) || next.contains(offPos)) continue;
                        next.add(offPos);
                        continue;
                    }
                    if (tile instanceof IPortalGroupTile && !((IPortalGroupTile)tile).hasGroup()) {
                        if (!frame.contains(offPos)) {
                            frame.add(offPos);
                            if (tile instanceof StabilizerTile) {
                                stabilizers.add(offPos);
                            }
                            if (tile instanceof IEnergyCellTile) {
                                energyCells.add(offPos);
                            }
                            if (tile instanceof ITargetCellTile) {
                                targetCells.add(offPos);
                            }
                        }
                        ++frames;
                        continue;
                    }
                    return null;
                }
                if (frames < 2) continue;
                corners.add(pos);
            }
            if (done.size() + current.size() + next.size() > WormholeConfig.maxPortalSize.get()) {
                return null;
            }
            done.addAll(current);
            current.clear();
            current.addAll(next);
            next.clear();
        }
        if (WormholeConfig.requireCorners.get().booleanValue()) {
            if (!PortalShape.validateCorners(world, done, frame, corners, stabilizers, energyCells, targetCells, axis)) {
                return null;
            }
        } else {
            PortalShape.collectCorners(world, done, frame, corners, stabilizers, energyCells, targetCells, axis);
        }
        if (stabilizers.size() == 0) {
            return null;
        }
        return new PortalShape(axis, done, frame, stabilizers, energyCells, targetCells);
    }

    private static void collectCorners(BlockGetter world, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> corners, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, Direction.Axis axis) {
        BlockPos dir1pos = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_142126_() : BlockPos.f_121853_.m_7494_();
        BlockPos dir1neg = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_142125_() : BlockPos.f_121853_.m_7495_();
        BlockPos dir2pos = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_142126_() : BlockPos.f_121853_.m_142127_();
        BlockPos dir2neg = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_142125_() : BlockPos.f_121853_.m_142128_();
        for (BlockPos corner : corners) {
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos);
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg);
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos);
            PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg);
        }
    }

    private static boolean validateCorners(BlockGetter world, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> corners, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, Direction.Axis axis) {
        BlockPos dir1pos = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_142126_() : BlockPos.f_121853_.m_7494_();
        BlockPos dir1neg = axis == Direction.Axis.Y ? BlockPos.f_121853_.m_142125_() : BlockPos.f_121853_.m_7495_();
        BlockPos dir2pos = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_142126_() : BlockPos.f_121853_.m_142127_();
        BlockPos dir2neg = axis == Direction.Axis.Z ? BlockPos.f_121853_.m_142125_() : BlockPos.f_121853_.m_142128_();
        for (BlockPos corner : corners) {
            if (!PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos)) {
                return false;
            }
            if (!PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg)) {
                return false;
            }
            if (!PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos)) {
                return false;
            }
            if (PortalShape.collectCorner(world, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectCorner(BlockGetter world, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells, BlockPos corner, BlockPos dir1, BlockPos dir2) {
        if (frame.contains(corner.m_141952_((Vec3i)dir1)) && frame.contains(corner.m_141952_((Vec3i)dir2))) {
            BlockPos pos = corner.m_141952_((Vec3i)dir1).m_141952_((Vec3i)dir2);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof IPortalGroupTile ? ((IPortalGroupTile)tile).hasGroup() : !area.contains(pos)) {
                return false;
            }
            if (!frame.contains(pos)) {
                frame.add(pos);
                if (tile instanceof StabilizerTile) {
                    stabilizers.add(pos);
                }
                if (tile instanceof IEnergyCellTile) {
                    energyCells.add(pos);
                }
                if (tile instanceof ITargetCellTile) {
                    targetCells.add(pos);
                }
            }
        }
        return true;
    }

    public PortalShape(Direction.Axis axis, List<BlockPos> area, List<BlockPos> frame, List<BlockPos> stabilizers, List<BlockPos> energyCells, List<BlockPos> targetCells) {
        this.axis = axis;
        this.area.addAll(area);
        this.frame.addAll(frame);
        this.stabilizers.addAll(stabilizers);
        this.energyCells.addAll(energyCells);
        this.targetCells.addAll(targetCells);
        double span = 0.0;
        int minX = frame.get(0).m_123341_();
        int minY = frame.get(0).m_123342_();
        int minZ = frame.get(0).m_123343_();
        int maxX = frame.get(0).m_123341_();
        int maxY = frame.get(0).m_123342_();
        int maxZ = frame.get(0).m_123343_();
        for (int i = 0; i < frame.size(); ++i) {
            BlockPos pos1 = frame.get(i);
            for (int j = i + 1; j < frame.size(); ++j) {
                BlockPos pos2 = frame.get(j);
                double distance = pos1.m_123331_((Vec3i)pos2);
                if (!(distance > span)) continue;
                span = distance;
            }
            if (pos1.m_123341_() < minX) {
                minX = pos1.m_123341_();
            }
            if (pos1.m_123342_() < minY) {
                minY = pos1.m_123342_();
            }
            if (pos1.m_123343_() < minZ) {
                minZ = pos1.m_123343_();
            }
            if (pos1.m_123341_() > maxX) {
                maxX = pos1.m_123341_();
            }
            if (pos1.m_123342_() > maxY) {
                maxY = pos1.m_123342_();
            }
            if (pos1.m_123343_() <= maxZ) continue;
            maxZ = pos1.m_123343_();
        }
        this.span = Math.sqrt(span);
        this.minCorner = new BlockPos(minX, minY, minZ);
        this.maxCorner = new BlockPos(maxX, maxY, maxZ);
    }

    public PortalShape(CompoundTag tag) {
        this.axis = Enum.valueOf(Direction.Axis.class, tag.m_128461_("axis"));
        CompoundTag areaTag = tag.m_128469_("area");
        for (Object key : areaTag.m_128431_()) {
            CompoundTag pos = areaTag.m_128469_((String)key);
            this.area.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
        }
        CompoundTag frameTag = tag.m_128469_("frame");
        for (Object key : frameTag.m_128431_()) {
            CompoundTag pos = frameTag.m_128469_((String)key);
            this.frame.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
        }
        CompoundTag stabilizerTag = tag.m_128469_("stabilizers");
        for (Object key : stabilizerTag.m_128431_()) {
            CompoundTag pos = stabilizerTag.m_128469_((String)key);
            this.stabilizers.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
        }
        CompoundTag energyCellsTag = tag.m_128469_("energyCells");
        for (String key : energyCellsTag.m_128431_()) {
            CompoundTag pos = energyCellsTag.m_128469_(key);
            this.energyCells.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
        }
        CompoundTag targetCellsTag = tag.m_128469_("targetCells");
        for (String key : targetCellsTag.m_128431_()) {
            CompoundTag pos = targetCellsTag.m_128469_(key);
            this.targetCells.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
        }
        this.span = tag.m_128459_("span");
        this.minCorner = new BlockPos(tag.m_128451_("minCornerX"), tag.m_128451_("minCornerY"), tag.m_128451_("minCornerZ"));
        this.maxCorner = new BlockPos(tag.m_128451_("maxCornerX"), tag.m_128451_("maxCornerY"), tag.m_128451_("maxCornerZ"));
    }

    public void createPortals(Level world, DyeColor color) {
        if (color == null) {
            color = DyeColor.values()[new Random().nextInt(DyeColor.values().length)];
        }
        for (BlockPos pos : this.area) {
            if (world.m_8055_(pos).m_60734_() instanceof PortalBlock && world.m_8055_(pos).m_61143_(PortalBlock.AXIS_PROPERTY) == this.axis && world.m_8055_(pos).m_61143_(PortalBlock.COLOR_PROPERTY) == color) continue;
            world.m_46597_(pos, (BlockState)((BlockState)Wormhole.portal.m_49966_().m_61124_(PortalBlock.AXIS_PROPERTY, (Comparable)this.axis)).m_61124_(PortalBlock.COLOR_PROPERTY, (Comparable)color));
        }
    }

    public void destroyPortals(Level world) {
        for (BlockPos pos : this.area) {
            if (!(world.m_8055_(pos).m_60734_() instanceof PortalBlock)) continue;
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public boolean validateFrame(BlockGetter world) {
        for (BlockPos pos : this.frame) {
            if (world.m_8055_(pos).m_60734_() instanceof IPortalGroupTile) continue;
            return false;
        }
        return true;
    }

    public boolean validatePortal(BlockGetter world) {
        for (BlockPos pos : this.area) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() instanceof PortalBlock && state.m_61143_(PortalBlock.AXIS_PROPERTY) == this.axis || state.m_60734_() == Blocks.f_50016_) continue;
            return false;
        }
        return true;
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("axis", this.axis.name());
        CompoundTag areaTag = new CompoundTag();
        for (int i = 0; i < this.area.size(); ++i) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.area.get(i).m_123341_());
            pos.m_128405_("y", this.area.get(i).m_123342_());
            pos.m_128405_("z", this.area.get(i).m_123343_());
            areaTag.m_128365_("" + i, (Tag)pos);
        }
        tag.m_128365_("area", (Tag)areaTag);
        CompoundTag frameTag = new CompoundTag();
        for (int i = 0; i < this.frame.size(); ++i) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.frame.get(i).m_123341_());
            pos.m_128405_("y", this.frame.get(i).m_123342_());
            pos.m_128405_("z", this.frame.get(i).m_123343_());
            frameTag.m_128365_("" + i, (Tag)pos);
        }
        tag.m_128365_("frame", (Tag)frameTag);
        CompoundTag stabilizerTag = new CompoundTag();
        for (int i = 0; i < this.stabilizers.size(); ++i) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.stabilizers.get(i).m_123341_());
            pos.m_128405_("y", this.stabilizers.get(i).m_123342_());
            pos.m_128405_("z", this.stabilizers.get(i).m_123343_());
            stabilizerTag.m_128365_("" + i, (Tag)pos);
        }
        tag.m_128365_("stabilizers", (Tag)stabilizerTag);
        CompoundTag energyCellsTag = new CompoundTag();
        for (int i = 0; i < this.energyCells.size(); ++i) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.energyCells.get(i).m_123341_());
            pos.m_128405_("y", this.energyCells.get(i).m_123342_());
            pos.m_128405_("z", this.energyCells.get(i).m_123343_());
            energyCellsTag.m_128365_("" + i, (Tag)pos);
        }
        tag.m_128365_("energyCells", (Tag)energyCellsTag);
        CompoundTag targetCellsTag = new CompoundTag();
        for (int i = 0; i < this.targetCells.size(); ++i) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.targetCells.get(i).m_123341_());
            pos.m_128405_("y", this.targetCells.get(i).m_123342_());
            pos.m_128405_("z", this.targetCells.get(i).m_123343_());
            targetCellsTag.m_128365_("" + i, (Tag)pos);
        }
        tag.m_128365_("targetCells", (Tag)targetCellsTag);
        tag.m_128347_("span", this.span);
        tag.m_128405_("minCornerX", this.minCorner.m_123341_());
        tag.m_128405_("minCornerY", this.minCorner.m_123342_());
        tag.m_128405_("minCornerZ", this.minCorner.m_123343_());
        tag.m_128405_("maxCornerX", this.maxCorner.m_123341_());
        tag.m_128405_("maxCornerY", this.maxCorner.m_123342_());
        tag.m_128405_("maxCornerZ", this.maxCorner.m_123343_());
        return tag;
    }

    public static PortalShape read(CompoundTag tag) {
        return new PortalShape(tag);
    }

    static {
        DIRECT_OFFSETS.put(Direction.Axis.X, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_(), BlockPos.f_121853_.m_7495_(), BlockPos.f_121853_.m_142127_(), BlockPos.f_121853_.m_142128_()}));
        DIRECT_OFFSETS.put(Direction.Axis.Y, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_142127_(), BlockPos.f_121853_.m_142126_(), BlockPos.f_121853_.m_142128_(), BlockPos.f_121853_.m_142125_()}));
        DIRECT_OFFSETS.put(Direction.Axis.Z, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_(), BlockPos.f_121853_.m_7495_(), BlockPos.f_121853_.m_142126_(), BlockPos.f_121853_.m_142125_()}));
        INDIRECT_OFFSETS.put(Direction.Axis.X, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_().m_142127_(), BlockPos.f_121853_.m_7494_().m_142128_(), BlockPos.f_121853_.m_7495_().m_142127_(), BlockPos.f_121853_.m_7495_().m_142128_()}));
        INDIRECT_OFFSETS.put(Direction.Axis.Y, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_142127_().m_142126_(), BlockPos.f_121853_.m_142127_().m_142125_(), BlockPos.f_121853_.m_142128_().m_142126_(), BlockPos.f_121853_.m_142128_().m_142125_()}));
        INDIRECT_OFFSETS.put(Direction.Axis.Z, Lists.newArrayList((Object[])new BlockPos[]{BlockPos.f_121853_.m_7494_().m_142126_(), BlockPos.f_121853_.m_7494_().m_142125_(), BlockPos.f_121853_.m_7495_().m_142126_(), BlockPos.f_121853_.m_7495_().m_142125_()}));
        for (Direction.Axis axis : Direction.Axis.values()) {
            ArrayList pos = new ArrayList();
            pos.addAll(DIRECT_OFFSETS.get(axis));
            pos.addAll(INDIRECT_OFFSETS.get(axis));
            ALL_OFFSETS.put(axis, pos);
        }
    }
}

