/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PortalTarget {
    public static final int MAX_NAME_LENGTH = 10;
    public final String dimension;
    public final int x;
    public final int y;
    public final int z;
    public final float yaw;
    public String name;
    public DyeColor color = null;
    public String dimensionDisplayName;

    public PortalTarget(String dimension, int x, int y, int z, float yaw, String name) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.name = name;
        Object dimensionName = dimension.substring(Math.min(dimension.length() - 1, Math.max(0, dimension.indexOf(58) + 1))).toLowerCase();
        dimensionName = ((String)dimensionName).substring(0, 1).toUpperCase() + ((String)dimensionName).substring(1);
        for (int i = 0; i < ((String)dimensionName).length() - 1; ++i) {
            if (((String)dimensionName).charAt(i) != '_' || !Character.isAlphabetic(((String)dimensionName).charAt(i + 1))) continue;
            dimensionName = ((String)dimensionName).substring(0, i) + " " + (String)(i + 2 < ((String)dimensionName).length() ? ((String)dimensionName).substring(i + 1, i + 2).toUpperCase() + ((String)dimensionName).substring(i + 2) : ((String)dimensionName).substring(i + 1).toUpperCase());
        }
        this.dimensionDisplayName = dimensionName;
    }

    public PortalTarget(Level world, BlockPos pos, float yaw, String name) {
        this(world.m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), yaw, name);
    }

    public PortalTarget(CompoundTag tag) {
        this(tag.m_128461_("dimension"), tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"), tag.m_128457_("yaw"), tag.m_128441_("name") ? tag.m_128461_("name") : "Target Destination");
        this.color = tag.m_128441_("color") ? DyeColor.m_41053_((int)tag.m_128451_("color")) : null;
        Object dimensionName = this.dimension.substring(Math.min(this.dimension.length() - 1, Math.max(0, this.dimension.indexOf(58) + 1))).toLowerCase();
        dimensionName = ((String)dimensionName).substring(0, 1).toUpperCase() + ((String)dimensionName).substring(1);
        for (int i = 0; i < ((String)dimensionName).length() - 1; ++i) {
            if (((String)dimensionName).charAt(i) != '_' || !Character.isAlphabetic(((String)dimensionName).charAt(i + 1))) continue;
            dimensionName = ((String)dimensionName).substring(0, i) + " " + (String)(i + 2 < ((String)dimensionName).length() ? ((String)dimensionName).substring(i + 1, i + 2).toUpperCase() + ((String)dimensionName).substring(i + 2) : ((String)dimensionName).substring(i + 1).toUpperCase());
        }
        this.dimensionDisplayName = dimensionName;
    }

    public static PortalTarget read(CompoundTag tag) {
        return new PortalTarget(tag);
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("dimension", this.dimension);
        tag.m_128405_("x", this.x);
        tag.m_128405_("y", this.y);
        tag.m_128405_("z", this.z);
        tag.m_128350_("yaw", this.yaw);
        tag.m_128359_("name", this.name);
        if (this.color != null) {
            tag.m_128405_("color", this.color.m_41060_());
        }
        return tag;
    }

    public Optional<Level> getWorld(MinecraftServer server) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.dimension));
        return Optional.ofNullable(server.m_129880_(key));
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vec3 getCenteredPos() {
        return new Vec3((double)this.x + 0.5, (double)this.y + 0.2, (double)this.z + 0.5);
    }

    public String getDimensionDisplayName() {
        return this.dimensionDisplayName;
    }
}

