/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.wormhole.ClientProxy;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellTile;
import com.supermartijn642.wormhole.energycell.EnergyCellTileRenderer;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellTile;
import com.supermartijn642.wormhole.targetcell.TargetCellTileRenderer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class PortalRendererHelper {
    private static final int ROTATE_TIME = 20000;

    public static void drawPortal(PortalShape shape, float x, float y, float width, float height) {
        Level world = ClientProxy.getWorld();
        float scale = Math.min(width, height) / ((float)shape.span + 1.0f);
        Vector3f center = new Vector3f((float)(shape.maxCorner.m_123341_() + shape.minCorner.m_123341_()) / 2.0f, (float)(shape.maxCorner.m_123342_() + shape.minCorner.m_123342_()) / 2.0f, (float)(shape.maxCorner.m_123343_() + shape.minCorner.m_123343_()) / 2.0f);
        PoseStack matrixstack = new PoseStack();
        matrixstack.m_85837_((double)(x + width / 2.0f), (double)(y + height / 2.0f), 350.0);
        matrixstack.m_85841_(1.0f, -1.0f, 1.0f);
        matrixstack.m_85841_(scale, scale, scale);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        matrixstack.m_85845_(new Quaternion(45.0f, (float)(System.currentTimeMillis() % 20000L) / 20000.0f * 360.0f, 0.0f, true));
        matrixstack.m_85837_((double)(-center.m_122239_()), (double)(-center.m_122260_()), (double)(-center.m_122269_()));
        for (BlockPos pos : shape.frame) {
            PortalRendererHelper.renderBlock(world, pos, matrixstack, (MultiBufferSource)renderTypeBuffer, true);
        }
        for (BlockPos pos : shape.area) {
            if (world.m_46859_(pos)) continue;
            PortalRendererHelper.renderBlock(world, pos, matrixstack, (MultiBufferSource)renderTypeBuffer, world.m_8055_(pos).m_60734_() instanceof PortalBlock);
            PortalRendererHelper.renderTileEntity(world, pos, matrixstack, (MultiBufferSource)renderTypeBuffer);
        }
        renderTypeBuffer.m_109911_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
    }

    private static void renderBlock(Level world, BlockPos pos, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, boolean valid) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof EnergyCellBlock) && !(state.m_60734_() instanceof TargetCellBlock) && state.m_60799_() != RenderShape.MODEL) {
            return;
        }
        BlockEntity tile = world.m_7702_(pos);
        BakedModel model = tile instanceof TargetCellTile ? TargetCellTileRenderer.getModelForTile((TargetCellTile)tile) : (tile instanceof EnergyCellTile ? EnergyCellTileRenderer.getModelForTile((EnergyCellTile)tile) : Minecraft.m_91087_().m_91289_().m_110910_(state));
        EmptyModelData modelData = tile == null ? EmptyModelData.INSTANCE : tile.getModelData();
        modelData = model.getModelData((BlockAndTintGetter)world, pos, state, (IModelData)modelData);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        PortalRendererHelper.translateAndRenderModel(state, matrixStack, renderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, model, (IModelData)modelData, valid);
        matrixStack.m_85849_();
    }

    private static void translateAndRenderModel(BlockState state, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn, IModelData modelData, boolean valid) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
        RenderType rendertype = RenderType.m_110466_();
        PortalRendererHelper.renderModel(modelIn, state, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn.m_6299_(rendertype), modelData, valid);
        matrixStackIn.m_85849_();
    }

    private static void renderModel(BakedModel modelIn, BlockState state, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, VertexConsumer bufferIn, IModelData modelData, boolean valid) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            PortalRendererHelper.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, direction, random, modelData), combinedLightIn, combinedOverlayIn, valid);
        }
        random.setSeed(42L);
        PortalRendererHelper.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, null, random, modelData), combinedLightIn, combinedOverlayIn, valid);
    }

    private static void renderQuads(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn, int combinedLightIn, int combinedOverlayIn, boolean valid) {
        PoseStack.Pose matrix = matrixStackIn.m_85850_();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.putBulkData(matrix, bakedquad, 1.0f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.8f, combinedLightIn, combinedOverlayIn, false);
        }
    }

    private static void renderTileEntity(Level world, BlockPos pos, PoseStack matrixStack, MultiBufferSource renderTypeBuffer) {
        BlockEntityRenderer tileRenderer;
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && (tileRenderer = ClientUtils.getMinecraft().m_167982_().m_112265_(tile)) != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)pos.m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5);
            tileRenderer.m_6922_(tile, Minecraft.m_91087_().m_91296_(), matrixStack, renderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_);
            matrixStack.m_85849_();
        }
    }
}

