/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ScreenBlockRenderer {
    public static void drawBlock(Block block, double x, double y, double scale, float yaw, float pitch) {
        BlockState state = block.m_49966_();
        PoseStack matrixstack = new PoseStack();
        matrixstack.m_85837_(x, y, 350.0);
        matrixstack.m_85841_(1.0f, -1.0f, 1.0f);
        matrixstack.m_85841_((float)scale, (float)scale, (float)scale);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        matrixstack.m_85845_(new Quaternion(pitch, yaw, 0.0f, true));
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        EmptyModelData modelData = EmptyModelData.INSTANCE;
        matrixstack.m_85837_(-0.5, -0.5, -0.5);
        RenderType rendertype = RenderType.m_110466_();
        ScreenBlockRenderer.renderModel(model, state, matrixstack, renderTypeBuffer.m_6299_(rendertype), (IModelData)modelData);
        renderTypeBuffer.m_109911_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
    }

    private static void renderModel(BakedModel modelIn, BlockState state, PoseStack matrixStackIn, VertexConsumer bufferIn, IModelData modelData) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, direction, random, modelData));
        }
        random.setSeed(42L);
        ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, null, random, modelData));
    }

    private static void renderQuads(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn) {
        PoseStack.Pose matrix = matrixStackIn.m_85850_();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.putBulkData(matrix, bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, false);
        }
    }
}

