/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ArrowButton
extends AbstractButtonWidget
implements IHoverTextWidget {
    private final ResourceLocation BUTTONS = new ResourceLocation("wormhole", "textures/gui/arrow_buttons.png");
    private final boolean up;

    public ArrowButton(int x, int y, boolean up, Runnable onPress) {
        super(x, y, 10, 5, onPress);
        this.up = up;
    }

    public ArrowButton(int x, int y, int width, int height, boolean up, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.up = up;
    }

    public Component getHoverText() {
        return this.active ? new TranslatableComponent("wormhole.gui.arrow_button." + (this.up ? "up" : "down")) : null;
    }

    protected Component getNarrationMessage() {
        return new TranslatableComponent("wormhole.gui.arrow_button." + (this.up ? "up" : "down"));
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenUtils.bindTexture((ResourceLocation)this.BUTTONS);
        float x = (float)(this.active ? (this.hovered ? 15 : 0) : 30) / 45.0f;
        float y = (float)(this.up ? 0 : 8) / 16.0f;
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)x, (float)y, (float)0.33333334f, (float)0.5f);
    }
}

