/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.wormhole.EnergyFormat;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class EnergyBarWidget
extends AbstractButtonWidget
implements IHoverTextWidget {
    private static final ResourceLocation BARS = new ResourceLocation("wormhole", "textures/gui/energy_bars.png");
    private final Supplier<Integer> energy;
    private final Supplier<Integer> capacity;

    public EnergyBarWidget(int x, int y, int width, int height, Supplier<Integer> energy, Supplier<Integer> capacity) {
        super(x, y, width, height, () -> EnergyFormat.cycleEnergyType(!Screen.m_96638_()));
        this.energy = energy;
        this.capacity = capacity;
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float percentage;
        ScreenUtils.bindTexture((ResourceLocation)BARS);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)(this.isHovered() ? 0.09090909f : 0.0f), (float)0.0f, (float)0.09090909f, (float)1.0f);
        int energy = this.energy.get();
        int capacity = this.capacity.get();
        float f = percentage = capacity == 0 ? 1.0f : Math.max(Math.min((float)energy / (float)capacity, 1.0f), 0.0f);
        if (percentage != 0.0f) {
            ScreenUtils.drawTexture((PoseStack)matrixStack, (float)this.x, (float)((float)this.y + (float)this.height * (1.0f - percentage)), (float)this.width, (float)((float)this.height * percentage), (float)0.27272728f, (float)(1.0f - percentage), (float)0.09090909f, (float)percentage);
        }
    }

    public Component getHoverText() {
        int energy = this.energy.get();
        int capacity = this.capacity.get();
        return new TextComponent(EnergyFormat.formatCapacity(energy, capacity));
    }

    protected Component getNarrationMessage() {
        return this.getHoverText();
    }
}

