/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class WormholeButton
extends AbstractButtonWidget {
    private final ResourceLocation BUTTONS = new ResourceLocation("wormhole", "textures/gui/buttons.png");
    protected String textKey;

    public WormholeButton(int x, int y, int width, int height, String textKey, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.textKey = textKey;
    }

    public void setTextKey(String textKey) {
        this.textKey = textKey;
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenUtils.bindTexture((ResourceLocation)this.getButtonTexture());
        this.drawBackground(matrixStack, this.x, this.y, this.width, this.height, (float)(this.active ? (this.isHovered() ? 5 : 0) : 10) / 15.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent(this.textKey), (float)((float)this.x + (float)this.width / 2.0f), (float)((float)this.y + (float)this.height / 2.0f - 4.0f), (int)(this.active ? -1 : Integer.MAX_VALUE));
    }

    protected ResourceLocation getButtonTexture() {
        return this.BUTTONS;
    }

    protected void drawBackground(PoseStack matrixStack, float x, float y, float width, float height, float yOffset) {
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)y, (float)2.0f, (float)2.0f, (float)0.0f, (float)yOffset, (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + width - 2.0f), (float)y, (float)2.0f, (float)2.0f, (float)0.6f, (float)yOffset, (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + width - 2.0f), (float)(y + height - 2.0f), (float)2.0f, (float)2.0f, (float)0.6f, (float)(yOffset + 0.2f), (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)(y + height - 2.0f), (float)2.0f, (float)2.0f, (float)0.0f, (float)(yOffset + 0.2f), (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + 2.0f), (float)y, (float)(width - 4.0f), (float)2.0f, (float)0.4f, (float)yOffset, (float)0.2f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + 2.0f), (float)(y + height - 2.0f), (float)(width - 4.0f), (float)2.0f, (float)0.4f, (float)(yOffset + 0.2f), (float)0.2f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)(y + 2.0f), (float)2.0f, (float)(height - 4.0f), (float)0.0f, (float)(yOffset + 0.13333334f), (float)0.4f, (float)0.06666667f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + width - 2.0f), (float)(y + 2.0f), (float)2.0f, (float)(height - 4.0f), (float)0.6f, (float)(yOffset + 0.13333334f), (float)0.4f, (float)0.06666667f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + 2.0f), (float)(y + 2.0f), (float)(width - 4.0f), (float)(height - 4.0f), (float)0.4f, (float)(yOffset + 0.13333334f), (float)0.2f, (float)0.06666667f);
    }

    protected Component getNarrationMessage() {
        return new TranslatableComponent(this.textKey);
    }
}

