/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.supermartijn642.wormhole.portal.ITargetCellTile;
import com.supermartijn642.wormhole.portal.PortalGroupTile;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

public class TargetCellTile
extends PortalGroupTile
implements ITargetCellTile {
    public final TargetCellType f_58855_;
    private final List<PortalTarget> targets = new ArrayList<PortalTarget>();

    public TargetCellTile(TargetCellType type, BlockPos pos, BlockState state) {
        super(type.getTileEntityType(), pos, state);
        this.f_58855_ = type;
        for (int i = 0; i < type.getCapacity(); ++i) {
            this.targets.add(null);
        }
    }

    @Override
    public int getTargetCapacity() {
        return this.f_58855_.getCapacity();
    }

    @Override
    public PortalTarget getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public void setTarget(int index, PortalTarget target) {
        this.targets.set(index, target);
        this.dataChanged();
    }

    @Override
    public List<PortalTarget> getTargets() {
        return this.targets;
    }

    @Override
    public int getNonNullTargetCount() {
        int count = 0;
        for (PortalTarget target : this.targets) {
            if (target == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag tag = super.writeData();
        CompoundTag targetsTag = new CompoundTag();
        int count = 0;
        for (int i = 0; i < this.targets.size(); ++i) {
            targetsTag.m_128379_("has" + i, this.targets.get(i) != null);
            if (this.targets.get(i) == null) continue;
            targetsTag.m_128365_("target" + i, (Tag)this.targets.get(i).write());
            count = i + 1;
        }
        tag.m_128405_("targetCount", count);
        tag.m_128365_("targets", (Tag)targetsTag);
        return tag;
    }

    @Override
    protected void readData(CompoundTag tag) {
        super.readData(tag);
        this.targets.clear();
        int count = tag.m_128441_("targetCount") ? tag.m_128451_("targetCount") : 0;
        CompoundTag targetsTag = tag.m_128469_("targets");
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            if (i < count && targetsTag.m_128441_("has" + i) && targetsTag.m_128471_("has" + i) && targetsTag.m_128441_("target" + i)) {
                this.targets.add(new PortalTarget(targetsTag.m_128469_("target" + i)));
                continue;
            }
            this.targets.add(null);
        }
    }

    public static class AdvancedTargetCellTile
    extends TargetCellTile {
        public AdvancedTargetCellTile(BlockPos pos, BlockState state) {
            super(TargetCellType.ADVANCED, pos, state);
        }
    }

    public static class BasicTargetCellTile
    extends TargetCellTile {
        public BasicTargetCellTile(BlockPos pos, BlockState state) {
            super(TargetCellType.BASIC, pos, state);
        }
    }
}

