/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.wormhole.targetcell.TargetCellTile;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class TargetCellTileRenderer
implements BlockEntityRenderer<TargetCellTile> {
    public static final ResourceLocation[] BASIC_TARGET_CELL_MODELS;
    public static final ResourceLocation[] ADVANCED_TARGET_CELL_MODELS;

    public void render(TargetCellTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ResourceLocation modelLocation = null;
        double percent = (double)tile.getNonNullTargetCount() / (double)tile.getTargetCapacity();
        if (tile.f_58855_ == TargetCellType.BASIC) {
            modelLocation = BASIC_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(BASIC_TARGET_CELL_MODELS.length - 1))];
        } else if (tile.f_58855_ == TargetCellType.ADVANCED) {
            modelLocation = ADVANCED_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(ADVANCED_TARGET_CELL_MODELS.length - 1))];
        }
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(modelLocation);
        ClientUtils.getBlockRenderer().m_110937_().renderModel(matrixStack.m_85850_(), buffer.m_6299_(RenderType.m_110451_()), tile.m_58900_(), model, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
    }

    public static BakedModel getModelForTile(TargetCellTile tile) {
        ResourceLocation modelLocation = null;
        double percent = (double)tile.getNonNullTargetCount() / (double)tile.getTargetCapacity();
        if (tile.f_58855_ == TargetCellType.BASIC) {
            modelLocation = BASIC_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(BASIC_TARGET_CELL_MODELS.length - 1))];
        } else if (tile.f_58855_ == TargetCellType.ADVANCED) {
            modelLocation = ADVANCED_TARGET_CELL_MODELS[(int)Math.ceil(Math.min(percent, 1.0) * (double)(ADVANCED_TARGET_CELL_MODELS.length - 1))];
        }
        return Minecraft.m_91087_().m_91304_().getModel(modelLocation);
    }

    static {
        int i;
        BASIC_TARGET_CELL_MODELS = new ResourceLocation[5];
        ADVANCED_TARGET_CELL_MODELS = new ResourceLocation[9];
        for (i = 0; i < 5; ++i) {
            TargetCellTileRenderer.BASIC_TARGET_CELL_MODELS[i] = new ResourceLocation("wormhole", "block/target_cell/basic_target_cell_" + i);
        }
        for (i = 0; i < 9; ++i) {
            TargetCellTileRenderer.ADVANCED_TARGET_CELL_MODELS[i] = new ResourceLocation("wormhole", "block/target_cell/advanced_target_cell_" + i);
        }
    }
}

