/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice;

import com.google.common.collect.Lists;
import com.supermartijn642.wormhole.ClientProxy;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TargetDeviceItem
extends Item {
    private final Supplier<Integer> maxTargetCount;

    public TargetDeviceItem(String registryName, Supplier<Integer> maxTargetCount) {
        super(new Item.Properties().m_41487_(1).m_41491_(Wormhole.ITEM_GROUP));
        this.maxTargetCount = maxTargetCount;
        this.setRegistryName(registryName);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            ClientProxy.openTargetDeviceScreen(handIn, playerIn.m_142538_(), Math.round(playerIn.m_146908_() / 90.0f) * 90);
        }
        return InteractionResultHolder.m_19096_((Object)playerIn.m_21120_(handIn));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("wormhole.target_device.info").m_130940_(ChatFormatting.AQUA));
        List<PortalTarget> targets = TargetDeviceItem.getTargets(stack);
        int capacity = TargetDeviceItem.getMaxTargetCount(stack);
        tooltip.add((Component)new TranslatableComponent("wormhole.target_device.info.targets", new Object[]{targets.size(), capacity}).m_130940_(ChatFormatting.YELLOW));
    }

    public static List<PortalTarget> getTargets(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("target")) {
            stack.m_41751_(null);
            TargetDeviceItem.setTargets(stack, Lists.newArrayList((Object[])new PortalTarget[]{PortalTarget.read(tag.m_128469_("target"))}));
            tag = stack.m_41784_();
        }
        if (!tag.m_128441_("targetCount")) {
            return new LinkedList<PortalTarget>();
        }
        int count = tag.m_128451_("targetCount");
        ArrayList<PortalTarget> targets = new ArrayList<PortalTarget>(count);
        for (int i = 0; i < count; ++i) {
            targets.add(new PortalTarget(tag.m_128469_("target" + i)));
        }
        return targets;
    }

    public static void setTargets(ItemStack stack, List<PortalTarget> targets) {
        if (targets == null || targets.size() == 0) {
            stack.m_41751_(null);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("targetCount", targets.size());
        for (int i = 0; i < targets.size(); ++i) {
            tag.m_128365_("target" + i, (Tag)targets.get(i).write());
        }
    }

    public static void addTarget(ItemStack stack, PortalTarget target) {
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        list.add(target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void removeTarget(ItemStack stack, int index) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list.remove(index);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void moveTarget(ItemStack stack, int index, boolean up) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        if (up ? index == 0 : index == list.size() - 1) {
            return;
        }
        PortalTarget target = list.remove(index);
        list.add(index + (up ? -1 : 1), target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void changeTargetName(ItemStack stack, int index, String name) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list.get((int)index).name = name;
        TargetDeviceItem.setTargets(stack, list);
    }

    public static int getMaxTargetCount(ItemStack stack) {
        return stack.m_41720_() instanceof TargetDeviceItem ? ((TargetDeviceItem)stack.m_41720_()).maxTargetCount.get() : -1;
    }
}

