/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.BaseScreen;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.screen.ScreenBlockRenderer;
import com.supermartijn642.wormhole.screen.WormholeColoredButton;
import com.supermartijn642.wormhole.screen.WormholeLabel;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceAddPacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceRemovePacket;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TargetDeviceScreen
extends BaseScreen {
    private static final ResourceLocation BACKGROUND = TargetDeviceScreen.getTexture("select_target_screen/device_background");
    private static final ResourceLocation SELECT_HIGHLIGHT = TargetDeviceScreen.getTexture("select_target_screen/device_select_highlight");
    private static final ResourceLocation HOVER_HIGHLIGHT = TargetDeviceScreen.getTexture("select_target_screen/device_hover_highlight");
    private static final ResourceLocation LOCATION_ICON = TargetDeviceScreen.getTexture("select_target_screen/location_icon");
    private static final ResourceLocation ENERGY_ICON = TargetDeviceScreen.getTexture("select_target_screen/lightning_icon");
    private static final ResourceLocation DIMENSION_ICON = TargetDeviceScreen.getTexture("select_target_screen/dimension_icon");
    private static final ResourceLocation DIRECTION_ICON = TargetDeviceScreen.getTexture("select_target_screen/direction_icon");
    private static final ResourceLocation SEPARATOR = TargetDeviceScreen.getTexture("select_target_screen/separator");
    private static final int WIDTH = 324;
    private static final int HEIGHT = 185;
    private final Player player;
    public final InteractionHand hand;
    private final BlockPos currentPos;
    private final float currentYaw;
    private int selectedTarget;
    private boolean selectedCurrentTarget = false;
    private TextFieldWidget currentTargetNameField;
    private final List<WormholeLabel> targetNameLabels = new LinkedList<WormholeLabel>();
    private WormholeColoredButton removeButton;

    private static ResourceLocation getTexture(String name) {
        return new ResourceLocation("wormhole", "textures/gui/" + name + ".png");
    }

    public TargetDeviceScreen(Player player, InteractionHand hand, BlockPos pos, float yaw) {
        super((Component)new TranslatableComponent("wormhole.target_device.gui.title"));
        this.player = player;
        this.hand = hand;
        this.currentPos = pos;
        this.currentYaw = yaw;
        this.selectedTarget = this.getOrDefault(list -> {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) continue;
                return i;
            }
            return -1;
        }, -1);
        if (this.selectedTarget == -1) {
            this.selectedCurrentTarget = true;
        }
    }

    protected float sizeX() {
        return 324.0f;
    }

    protected float sizeY() {
        return 185.0f;
    }

    protected void addWidgets() {
        int targetCapacity = this.getFromStack(TargetDeviceItem::getMaxTargetCount, 0);
        int count = 0;
        while (count < Math.min(10, targetCapacity)) {
            int index = count++;
            int y = 18 + index * 16;
            this.targetNameLabels.add((WormholeLabel)this.addWidget(new WormholeLabel(7, y, 102, 12, () -> this.getOrDefault(list -> list.size() > index ? ((PortalTarget)list.get((int)index)).name : "", ""), false)));
        }
        this.currentTargetNameField = (TextFieldWidget)this.addWidget((Widget)new TextFieldWidget(215, 18, 102, 12, "", 10));
        this.currentTargetNameField.setSuggestion(I18n.m_118938_((String)"wormhole.target_device.gui.target_name", (Object[])new Object[0]));
        if (this.selectedCurrentTarget) {
            this.currentTargetNameField.setFocused(true);
        }
        this.removeButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(131, 160, 62, 11, "", () -> {
            if (this.selectedTarget >= 0) {
                Wormhole.CHANNEL.sendToServer((Object)new TargetDeviceRemovePacket(this.hand, this.selectedTarget));
            } else if (this.selectedCurrentTarget) {
                Wormhole.CHANNEL.sendToServer((Object)new TargetDeviceAddPacket(this.hand, this.currentTargetNameField.getText().trim(), this.currentPos, this.currentYaw));
            }
        }));
    }

    protected void render(PoseStack matrixStack, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (float)58.0f, (float)3.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"wormhole.target_device.gui.current_location", (Object[])new Object[0]), (float)266.0f, (float)3.0f, (int)Integer.MAX_VALUE);
        if (this.selectedTarget >= 0) {
            ScreenUtils.bindTexture((ResourceLocation)SELECT_HIGHLIGHT);
            ScreenUtils.drawTexture((PoseStack)matrixStack, (float)5.0f, (float)(16 + 16 * this.selectedTarget), (float)106.0f, (float)16.0f);
        } else if (this.selectedCurrentTarget) {
            ScreenUtils.bindTexture((ResourceLocation)SELECT_HIGHLIGHT);
            ScreenUtils.drawTexture((PoseStack)matrixStack, (float)213.0f, (float)16.0f, (float)106.0f, (float)16.0f);
        }
        if (mouseX > 5 && mouseX < 111 && mouseY > 16 && mouseY < 176) {
            int targetIndex = (mouseY - 16) / 16;
            if (this.getOrDefault(list -> list.size() > targetIndex && list.get(targetIndex) != null, false).booleanValue()) {
                ScreenUtils.bindTexture((ResourceLocation)HOVER_HIGHLIGHT);
                ScreenUtils.drawTexture((PoseStack)matrixStack, (float)5.0f, (float)(16 + targetIndex * 16), (float)106.0f, (float)16.0f);
            }
        } else if (mouseX > 213 && mouseX < 319 && mouseY > 16 && mouseY < 32) {
            ScreenUtils.bindTexture((ResourceLocation)HOVER_HIGHLIGHT);
            ScreenUtils.drawTexture((PoseStack)matrixStack, (float)213.0f, (float)16.0f, (float)106.0f, (float)16.0f);
        }
        if (this.selectedTarget >= 0) {
            PortalTarget target = this.getOrDefault(list -> list.size() > this.selectedTarget ? (PortalTarget)list.get(this.selectedTarget) : null, null);
            if (target != null) {
                this.renderTargetInfo(matrixStack, target.name, target.getPos(), target.dimension, target.dimensionDisplayName, target.yaw);
            }
        } else if (this.selectedCurrentTarget) {
            String dimension = this.player.f_19853_.m_46472_().m_135782_().toString();
            Object dimensionName = dimension.substring(Math.min(dimension.length() - 1, Math.max(0, dimension.indexOf(58) + 1))).toLowerCase();
            dimensionName = ((String)dimensionName).substring(0, 1).toUpperCase() + ((String)dimensionName).substring(1);
            for (int i = 0; i < ((String)dimensionName).length() - 1; ++i) {
                if (((String)dimensionName).charAt(i) != '_' || !Character.isAlphabetic(((String)dimensionName).charAt(i + 1))) continue;
                dimensionName = ((String)dimensionName).substring(0, i) + " " + (String)(i + 2 < ((String)dimensionName).length() ? ((String)dimensionName).substring(i + 1, i + 2).toUpperCase() + ((String)dimensionName).substring(i + 2) : ((String)dimensionName).substring(i + 1).toUpperCase());
            }
            this.renderTargetInfo(matrixStack, this.currentTargetNameField.getText().trim(), this.currentPos, dimension, (String)dimensionName, this.currentYaw);
        }
        this.updateAddRemoveButton();
    }

    private void renderTargetInfo(PoseStack matrixStack, String name, BlockPos pos, String dimension, String dimensionName, float yaw) {
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (String)name, (float)162.0f, (float)31.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)SEPARATOR);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)124.0f, (float)41.0f, (float)77.0f, (float)1.0f);
        ScreenUtils.bindTexture((ResourceLocation)LOCATION_ICON);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)121.0f, (float)47.0f, (float)9.0f, (float)9.0f);
        ScreenUtils.drawString((PoseStack)matrixStack, (Font)this.f_96547_, (String)("(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")"), (float)132.0f, (float)48.0f, (int)Integer.MAX_VALUE);
        Block block = null;
        if (dimension.equals(Level.f_46428_.m_135782_().toString())) {
            block = Blocks.f_152481_;
        } else if (dimension.equals(Level.f_46429_.m_135782_().toString())) {
            block = Blocks.f_50134_;
        } else if (dimension.equals(Level.f_46430_.m_135782_().toString())) {
            block = Blocks.f_50259_;
        }
        if (block == null) {
            ScreenUtils.bindTexture((ResourceLocation)DIMENSION_ICON);
            ScreenUtils.drawTexture((PoseStack)matrixStack, (float)121.0f, (float)59.0f, (float)9.0f, (float)9.0f);
        } else {
            ScreenBlockRenderer.drawBlock(block, (double)this.left() + 125.5, (double)this.top() + 63.5, 5.5, 45.0f, 40.0f);
        }
        ScreenUtils.drawString((PoseStack)matrixStack, (Font)this.f_96547_, (String)dimensionName, (float)132.0f, (float)60.0f, (int)Integer.MAX_VALUE);
        ScreenUtils.bindTexture((ResourceLocation)DIRECTION_ICON);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)119.0f, (float)69.0f, (float)13.0f, (float)13.0f);
        ScreenUtils.drawString((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)("wormhole.direction." + Direction.m_122364_((double)yaw).toString()), (Object[])new Object[0]), (float)132.0f, (float)72.0f, (int)Integer.MAX_VALUE);
    }

    protected void renderTooltips(PoseStack matrixStack, int mouseX, int mouseY) {
        if (mouseX >= 120 && mouseX <= 131 && mouseY >= 46 && mouseY <= 57) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("wormhole.target.location"), mouseX, mouseY);
        } else if (mouseX >= 120 && mouseX <= 131 && mouseY >= 58 && mouseY <= 69) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("wormhole.target.dimension"), mouseX, mouseY);
        } else if (mouseX >= 120 && mouseX <= 131 && mouseY >= 70 && mouseY <= 81) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("wormhole.target.direction"), mouseX, mouseY);
        }
    }

    private void updateAddRemoveButton() {
        if (this.selectedTarget >= 0) {
            boolean notEmpty = this.getOrDefault(list -> list.size() > this.selectedTarget && list.get(this.selectedTarget) != null, false);
            this.removeButton.setVisible();
            this.removeButton.setColorRed();
            this.removeButton.setTextKey("wormhole.portal.targets.gui.remove");
            this.removeButton.active = notEmpty;
        } else if (this.selectedCurrentTarget) {
            boolean notEmpty = !this.currentTargetNameField.getText().trim().isEmpty();
            boolean space = this.getOrDefault(list -> {
                if (list.size() < this.getFromStack(TargetDeviceItem::getMaxTargetCount, 0)) {
                    return true;
                }
                for (PortalTarget target : list) {
                    if (target != null) continue;
                    return true;
                }
                return false;
            }, false);
            this.removeButton.setVisible();
            this.removeButton.setColorWhite();
            this.removeButton.setTextKey("wormhole.portal.targets.gui.add");
            this.removeButton.active = notEmpty && space;
        } else {
            this.removeButton.setInvisible();
        }
    }

    public <T> T getOrDefault(Function<List<PortalTarget>, T> function, T other) {
        ItemStack stack = this.player.m_21120_(this.hand);
        if (!stack.m_41619_() && stack.m_41720_() instanceof TargetDeviceItem) {
            return function.apply(TargetDeviceItem.getTargets(stack));
        }
        this.m_7379_();
        return other;
    }

    public <T> T getFromStack(Function<ItemStack, T> function, T other) {
        ItemStack stack = this.player.m_21120_(this.hand);
        if (!stack.m_41619_() && stack.m_41720_() instanceof TargetDeviceItem) {
            return function.apply(stack);
        }
        this.m_7379_();
        return other;
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
        if (button != 0) {
            return;
        }
        if (mouseX > 5 && mouseX < 111 && mouseY > 16 && mouseY < 176) {
            int targetIndex = (mouseY - 16) / 16;
            if (this.getOrDefault(list -> list.size() > targetIndex && list.get(targetIndex) != null, false).booleanValue()) {
                AbstractButtonWidget.playClickSound();
                this.selectedTarget = targetIndex;
                this.selectedCurrentTarget = false;
            }
        } else if (mouseX > 213 && mouseX < 319 && mouseY > 16 && mouseY < 32) {
            AbstractButtonWidget.playClickSound();
            this.selectedTarget = -1;
            this.selectedCurrentTarget = true;
        }
    }
}

