/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice.packets;

import com.supermartijn642.wormhole.packet.TargetDevicePacket;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TargetDeviceAddPacket
extends TargetDevicePacket {
    private String name;
    private BlockPos pos;
    private float yaw;

    public TargetDeviceAddPacket(InteractionHand hand, String name, BlockPos pos, float yaw) {
        super(hand);
        this.name = name;
        this.pos = pos;
        this.yaw = yaw;
    }

    public TargetDeviceAddPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130070_(this.name);
        buffer.m_130064_(this.pos);
        buffer.writeFloat(this.yaw);
    }

    @Override
    protected void decodeBuffer(FriendlyByteBuf buffer) {
        super.decodeBuffer(buffer);
        this.name = buffer.m_130136_(Short.MAX_VALUE).trim();
        this.pos = buffer.m_130135_();
        this.yaw = buffer.readFloat();
    }

    @Override
    protected void handle(Player player, Level world, ItemStack targetDevice) {
        if (this.name.isEmpty()) {
            return;
        }
        List<PortalTarget> targets = TargetDeviceItem.getTargets(targetDevice);
        if (targets.size() < TargetDeviceItem.getMaxTargetCount(targetDevice)) {
            TargetDeviceItem.addTarget(targetDevice, new PortalTarget(world, this.pos, this.yaw, this.name));
        }
    }
}

