/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.relations.ExternalWaystoneLibrary;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public interface WaystoneHandle {
    public void write(FriendlyByteBuf var1);

    public void write(CompoundTag var1);

    public static Optional<WaystoneHandle> read(FriendlyByteBuf buffer) {
        String type = StringSerializer.instance.read(buffer);
        if (type.equals("vanilla")) {
            return Optional.of((WaystoneHandle)Vanilla.Serializer.read(buffer));
        }
        return ExternalWaystoneLibrary.getInstance().read(type, buffer);
    }

    public static Optional<WaystoneHandle> read(CompoundTag compound) {
        String type = compound.m_128461_("type");
        if (type.equals("vanilla")) {
            return Optional.of((WaystoneHandle)Vanilla.Serializer.read(compound));
        }
        return ExternalWaystoneLibrary.getInstance().read(type, compound);
    }

    public static class Vanilla
    implements WaystoneHandle {
        public static final String typeTag = "vanilla";
        public static final Vanilla NIL = new Vanilla(Util.f_137441_);
        public final UUID id;
        public static final CompoundSerializable<Vanilla> Serializer = new SerializerImpl();

        public Vanilla(UUID id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vanilla that = (Vanilla)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130070_(typeTag);
            Serializer.write(this, buffer);
        }

        @Override
        public void write(CompoundTag compound) {
            Serializer.write(this, compound);
        }

        public static final class SerializerImpl
        implements CompoundSerializable<Vanilla> {
            @Override
            public CompoundTag write(Vanilla playerHandle, CompoundTag compound) {
                compound.m_128359_("type", Vanilla.typeTag);
                compound.m_128362_("Id", playerHandle.id);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundTag compound) {
                return compound.m_128441_("Id");
            }

            @Override
            public Vanilla read(CompoundTag compound) {
                return new Vanilla(compound.m_128342_("Id"));
            }

            @Override
            public Class<Vanilla> getTargetClass() {
                return Vanilla.class;
            }

            @Override
            public void write(Vanilla playerHandle, FriendlyByteBuf buffer) {
                buffer.m_130077_(playerHandle.id);
            }

            @Override
            public Vanilla read(FriendlyByteBuf buffer) {
                return new Vanilla(buffer.m_130259_());
            }
        }
    }
}

