/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.LargeSignRenderer;
import gollorum.signpost.blockpartdata.types.renderers.PostRenderer;
import gollorum.signpost.blockpartdata.types.renderers.ShortSignRenderer;
import gollorum.signpost.blockpartdata.types.renderers.WaystoneRenderer;
import gollorum.signpost.blockpartdata.types.renderers.WideSignRenderer;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class BlockPartRenderer<T extends BlockPart<T>> {
    private static final Map<Class<? extends BlockPart>, BlockPartRenderer<? extends BlockPart>> renderers = new ConcurrentHashMap<Class<? extends BlockPart>, BlockPartRenderer<? extends BlockPart>>();

    public static <T extends BlockPart<T>> void register(Class<T> blockPartClass, BlockPartRenderer<T> renderer) {
        renderers.put(blockPartClass, renderer);
    }

    public static <T extends BlockPart<T>> Optional<BlockPartRenderer<T>> getFor(Class<T> blockPartClass) {
        return Optional.ofNullable(renderers.get(blockPartClass)).map(renderer -> renderer);
    }

    public static <T extends BlockPart<T>> void renderDynamic(T part, BlockEntity tileEntity, BlockEntityRenderDispatcher renderDispatcher, PoseStack matrix, MultiBufferSource buffer, int combinedLights, int combinedOverlay, Random random, long randomSeed) {
        Optional<BlockPartRenderer<?>> renderer = BlockPartRenderer.getFor(part.getClass());
        if (renderer.isPresent()) {
            renderer.get().render(part, tileEntity, renderDispatcher, matrix, buffer, combinedLights, combinedOverlay, random, randomSeed);
        } else {
            Signpost.LOGGER.error("Block part renderer was not found for " + part.getClass());
        }
    }

    public static <T extends BlockPart<T>> void renderGuiDynamic(T part, PoseStack matrixStack, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset) {
        Optional<BlockPartRenderer<?>> renderer = BlockPartRenderer.getFor(part.getClass());
        if (renderer.isPresent()) {
            renderer.get().renderGui(part, matrixStack, center, yaw, pitch, isFlipped, scale, offset);
        } else {
            Signpost.LOGGER.error("Block part renderer was not found for " + part.getClass());
        }
    }

    public static <T extends BlockPart<T>> void renderGuiDynamic(T part, PoseStack matrixStack, Vector3 offset, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Optional<BlockPartRenderer<?>> renderer = BlockPartRenderer.getFor(part.getClass());
        if (renderer.isPresent()) {
            renderer.get().renderGui(part, matrixStack, offset, buffer, combinedLight, combinedOverlay);
        } else {
            Signpost.LOGGER.error("Block part renderer was not found for " + part.getClass());
        }
    }

    public abstract void render(T var1, BlockEntity var2, BlockEntityRenderDispatcher var3, PoseStack var4, MultiBufferSource var5, int var6, int var7, Random var8, long var9);

    public abstract void renderGui(T var1, PoseStack var2, Point var3, Angle var4, Angle var5, boolean var6, float var7, Vector3 var8);

    public abstract void renderGui(T var1, PoseStack var2, Vector3 var3, MultiBufferSource var4, int var5, int var6);

    static {
        BlockPartRenderer.register(PostBlockPart.class, new PostRenderer());
        BlockPartRenderer.register(SmallWideSignBlockPart.class, new WideSignRenderer());
        BlockPartRenderer.register(SmallShortSignBlockPart.class, new ShortSignRenderer());
        BlockPartRenderer.register(LargeSignBlockPart.class, new LargeSignRenderer());
        BlockPartRenderer.register(WaystoneBlockPart.class, new WaystoneRenderer());
    }
}

