/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.rendering.ModelRegistry;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.modelGeneration.SignModel;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;

public class LargeSignRenderer
extends SignRenderer<LargeSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = 0.4375f;
    private static final float TEXT_OFFSET_LEFT_SHORT = 0.5625f;
    private static final float TEXT_OFFSET_LEFT_LONG = 0.625f;
    private static final float MAXIMUM_TEXT_WIDTH_SHORT = 1.0f;
    private static final float MAXIMUM_TEXT_WIDTH_LONG = 1.0625f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected BakedModel makeBakedModel(LargeSignBlockPart sign) {
        return ModelRegistry.LargeBakedSign.makeModel(sign);
    }

    @Override
    protected BakedModel makeBakedOverlayModel(LargeSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.LargeBakedSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected SignModel makeModel(LargeSignBlockPart sign) {
        return ModelRegistry.LargeSign.makeModel(sign);
    }

    @Override
    protected SignModel makeOverlayModel(LargeSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.LargeSign.makeOverlayModel(sign, overlay);
    }

    @Override
    public void renderText(LargeSignBlockPart sign, PoseStack matrix, Font fontRenderer, MultiBufferSource buffer, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            matrix.m_85837_(0.0, 0.21875, -0.1878125);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[3], matrix, buffer, combinedLights, false));
            matrix.m_85837_(0.0, -0.1458333283662796, 0.0);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[2], matrix, buffer, combinedLights, false));
            matrix.m_85837_(0.0, -0.1458333283662796, 0.0);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[1], matrix, buffer, combinedLights, false));
            matrix.m_85837_(0.0, -0.1458333283662796, 0.0);
            RenderingUtil.wrapInMatrixEntry(matrix, () -> this.render(sign, fontRenderer, sign.getText()[0], matrix, buffer, combinedLights, false));
        });
    }

    private void render(LargeSignBlockPart sign, Font fontRenderer, String text, PoseStack matrix, MultiBufferSource buffer, int combinedLights, boolean isLong) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.m_92895_(text) * scale / (isLong ? 1.0625f : 1.0f);
            float offset = 0.4375f * Math.min(1.0f, MAX_WIDTH_FRAC);
            matrix.m_85837_(sign.isFlipped() ? (double)(offset - (float)fontRenderer.m_92895_(text) * (scale /= Math.max(1.0f, MAX_WIDTH_FRAC))) : (double)(-offset), (double)(-scale * 4.0f * 1.3f), 0.0);
            matrix.m_85841_(scale, scale * 1.3f, scale);
            fontRenderer.m_92811_(text, 0.0f, 0.0f, sign.getColor(), false, matrix.m_85850_().m_85861_(), buffer, false, 0, combinedLights);
        });
    }
}

