/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.items.Wrench;
import gollorum.signpost.minecraft.utils.SideUtils;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ItemStackSerializer;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import gollorum.signpost.utils.serialization.StringSerializer;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkEvent;

public class PostTile
extends BlockEntity
implements WithOwner.OfSignpost,
WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "post";
    private static BlockEntityType<PostTile> type = null;
    private final Map<UUID, BlockPartInstance> parts = new ConcurrentHashMap<UUID, BlockPartInstance>();
    public static final Set<BlockPartMetadata<?>> partsMetadata = new ConcurrentSet();
    public final PostBlock.ModelType modelType;
    private ItemStack drop;
    private Optional<PlayerHandle> owner = Optional.empty();

    public static BlockEntityType<PostTile> createType() {
        assert (type == null);
        type = BlockEntityType.Builder.m_155273_((pos, state) -> new PostTile(PostBlock.ModelType.Oak, ItemStack.f_41583_, pos, state), (Block[])PostBlock.getAllBlocks()).m_58966_(null);
        return type;
    }

    public static BlockEntityType<PostTile> getBlockEntityType() {
        assert (type != null);
        return type;
    }

    public PostTile(PostBlock.ModelType modelType, ItemStack drop, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.modelType = modelType;
        this.drop = drop;
    }

    public UUID addPart(BlockPartInstance part, ItemStack cost, PlayerHandle player) {
        return this.addPart(UUID.randomUUID(), part, cost, player);
    }

    public UUID addPart(UUID identifier, BlockPartInstance part, ItemStack cost, PlayerHandle player) {
        this.parts.put(identifier, part);
        if (this.m_58898_() && !this.m_58904_().m_5776_()) {
            this.sendToTracing(() -> new PartAddedEvent.Packet(new TilePartInfo(this, identifier), part.blockPart.write(), part.blockPart.getMeta().identifier, part.offset, cost, player));
        }
        return identifier;
    }

    public BlockPartInstance removePart(UUID id) {
        BlockPartInstance oldPart = this.parts.remove(id);
        if (oldPart == null) {
            Signpost.LOGGER.error("Failed to remove post block part with id " + id);
            return oldPart;
        }
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            this.sendToTracing(() -> new PartRemovedEvent.Packet(new TilePartInfo(this, id), false));
        }
        oldPart.blockPart.removeFrom(this);
        this.m_6596_();
        return oldPart;
    }

    public void onDestroy() {
        for (BlockPartInstance part : this.parts.values()) {
            part.blockPart.removeFrom(this);
        }
    }

    public Collection<BlockPartInstance> getParts() {
        return this.parts.values();
    }

    public VoxelShape getBounds() {
        return this.parts.values().stream().map(t -> t.blockPart.getIntersection().getBounds().offset(t.offset).asMinecraftBB()).map(Shapes::m_83064_).reduce((b1, b2) -> Shapes.m_83113_((VoxelShape)b1, (VoxelShape)b2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
    }

    public AABB getRenderBoundingBox() {
        VoxelShape shape = this.getBounds();
        return shape.m_83281_() ? new AABB(this.m_58899_()) : shape.m_83215_().m_82338_(this.m_58899_());
    }

    public Optional<TraceResult> trace(Entity player) {
        Vec3 head = player.m_20182_();
        head = head.m_82520_(0.0, (double)player.m_20192_(), 0.0);
        if (player.m_6047_()) {
            head = head.m_82492_(0.0, 0.08, 0.0);
        }
        Vec3 look = player.m_20154_();
        Ray ray = new Ray(Vector3.fromVec3d(head).subtract(Vector3.fromBlockPos(this.m_58899_())), Vector3.fromVec3d(look));
        Optional<Tuple> closestTrace = Optional.empty();
        for (Map.Entry<UUID, BlockPartInstance> t : this.parts.entrySet()) {
            Optional<Float> now = t.getValue().blockPart.intersectWith(ray, t.getValue().offset);
            if (!now.isPresent() || closestTrace.isPresent() && !(((Float)((Tuple)closestTrace.get()).m_14419_()).floatValue() > now.get().floatValue())) continue;
            closestTrace = Optional.of(new Tuple((Object)t.getKey(), (Object)now.get()));
        }
        return closestTrace.map(trace -> new TraceResult(this.parts.get(trace.m_14418_()), (UUID)trace.m_14418_(), ray.atDistance(((Float)trace.m_14419_()).floatValue()), ray));
    }

    public void m_183515_(CompoundTag compound) {
        this.writeSelf(compound);
    }

    public Tag writeParts(boolean includeIDs) {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<BlockPartMetadata, List<Map.Entry>> entry : this.parts.entrySet().stream().collect(Collectors.groupingBy(p -> ((BlockPartInstance)p.getValue()).blockPart.getMeta())).entrySet()) {
            List<Map.Entry> instances = entry.getValue();
            ListTag list = new ListTag();
            for (Map.Entry e : instances) {
                BlockPartInstance instance = (BlockPartInstance)e.getValue();
                CompoundTag subComp = instance.blockPart.write();
                subComp.m_128365_("Offset", (Tag)Vector3.Serializer.write(instance.offset));
                if (includeIDs) {
                    subComp.m_128362_("PartId", (UUID)e.getKey());
                }
                list.add((Object)subComp);
            }
            compound.m_128365_(entry.getKey().identifier, (Tag)list);
        }
        return compound;
    }

    private void writeSelf(CompoundTag compound) {
        compound.m_128365_("Parts", this.writeParts(true));
        compound.m_128365_("Drop", (Tag)ItemStackSerializer.Instance.write(this.drop));
        compound.m_128365_("Owner", (Tag)PlayerHandle.Serializer.optional().write(this.owner));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readSelf(compound);
    }

    public static List<BlockPartInstance> readPartInstances(CompoundTag compound) {
        ArrayList<BlockPartInstance> parts = new ArrayList<BlockPartInstance>();
        for (BlockPartMetadata<?> meta : partsMetadata) {
            if (!compound.m_128441_(meta.identifier)) continue;
            ListTag list = compound.m_128437_(meta.identifier, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag comp = list.m_128728_(i);
                parts.add(new BlockPartInstance((BlockPart)meta.read(comp), Vector3.Serializer.read(comp.m_128469_("Offset"))));
            }
        }
        return parts;
    }

    public void readParts(CompoundTag compound) {
        this.parts.clear();
        for (BlockPartMetadata<?> meta : partsMetadata) {
            if (!compound.m_128441_(meta.identifier)) continue;
            ListTag list = compound.m_128437_(meta.identifier, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag comp = list.m_128728_(i);
                this.addPart(comp.m_128441_("PartId") ? comp.m_128342_("PartId") : UUID.randomUUID(), new BlockPartInstance((BlockPart)meta.read(comp), Vector3.Serializer.read(comp.m_128469_("Offset"))), ItemStack.f_41583_, PlayerHandle.Invalid);
            }
        }
    }

    private void readSelf(CompoundTag compound) {
        this.readParts(compound.m_128469_("Parts"));
        this.drop = ItemStackSerializer.Instance.read(compound.m_128469_("Drop"));
        this.owner = ((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.m_128469_("Owner"));
    }

    public CompoundTag m_5995_() {
        CompoundTag ret = super.m_5995_();
        this.writeSelf(ret);
        return ret;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag ret = new CompoundTag();
        this.writeSelf(ret);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, unused -> ret);
    }

    public void handleUpdateTag(CompoundTag compound) {
        super.handleUpdateTag(compound);
        this.readSelf(compound);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.readSelf(pkt.m_131708_());
    }

    public void notifyMutation(UUID part, CompoundTag data, String partMetaIdentifier) {
        this.sendToTracing(() -> new PartMutatedEvent.Packet(new TilePartInfo(this, part), data, partMetaIdentifier));
    }

    public <T> void sendToTracing(Supplier<T> t) {
        PacketHandler.sendToTracing(this, t);
    }

    public Collection<ItemStack> getDrops() {
        List<ItemStack> ret = this.parts.values().stream().flatMap(p -> p.blockPart.getDrops(this).stream()).collect(Collectors.toList());
        return ret;
    }

    public void setSignpostOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    @Override
    public Optional<PlayerHandle> getSignpostOwner() {
        return this.owner;
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.getParts().stream().filter(p -> p.blockPart instanceof WaystoneBlockPart).findFirst().flatMap(p -> ((WaystoneBlockPart)p.blockPart).getWaystoneOwner());
    }

    public static boolean isAngleTool(Item item) {
        return item instanceof Wrench;
    }

    public Optional<BlockPartInstance> getPart(UUID id) {
        return this.parts.containsKey(id) ? Optional.of(this.parts.get(id)) : Optional.empty();
    }

    static {
        partsMetadata.add(PostBlockPart.METADATA);
        partsMetadata.add(SmallWideSignBlockPart.METADATA);
        partsMetadata.add(SmallShortSignBlockPart.METADATA);
        partsMetadata.add(LargeSignBlockPart.METADATA);
        partsMetadata.add(WaystoneBlockPart.METADATA);
    }

    public static class PartMutatedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            TilePartInfo.Serializer.write(message.info, buffer);
            StringSerializer.instance.write(message.data.toString(), buffer);
            StringSerializer.instance.write(message.partMetaIdentifier, buffer);
            Vector3.Serializer.optional().write(message.offset, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            try {
                return new Packet(TilePartInfo.Serializer.read(buffer), TagParser.m_129359_((String)StringSerializer.instance.read(buffer)), StringSerializer.instance.read(buffer), (Optional<Vector3>)Vector3.Serializer.optional().read(buffer));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            boolean isServer = context.getDirection().getReceptionSide().isServer();
            TileEntityUtils.findWorld(message.info.dimensionKey, !isServer).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(new WorldLocation(message.info.pos, (Level)level), PostTile.class, tile -> {
                Optional<BlockPartInstance> part = tile.getPart(message.info.identifier);
                if (part.isPresent()) {
                    BlockPartInstance blockPartInstance = part.get();
                    if (blockPartInstance.blockPart.getMeta().identifier.equals(message.partMetaIdentifier)) {
                        blockPartInstance.blockPart.readMutationUpdate(message.data, (BlockEntity)tile, (Player)(isServer ? context.getSender() : null));
                        if (message.offset.isPresent()) {
                            tile.parts.remove(message.info.identifier);
                            tile.parts.put(message.info.identifier, new BlockPartInstance(blockPartInstance.blockPart, message.offset.get()));
                        }
                    } else {
                        Optional<BlockPartMetadata> meta = partsMetadata.stream().filter(m -> m.identifier.equals(message.partMetaIdentifier)).findFirst();
                        if (meta.isPresent()) {
                            tile.parts.remove(message.info.identifier);
                            tile.parts.put(message.info.identifier, new BlockPartInstance((BlockPart)meta.get().read(message.data), message.offset.orElse(blockPartInstance.offset)));
                        } else {
                            Signpost.LOGGER.warn("Could not find meta for part " + message.partMetaIdentifier);
                        }
                    }
                    tile.m_6596_();
                    if (isServer) {
                        tile.sendToTracing(() -> message);
                    }
                } else {
                    Signpost.LOGGER.error("Tried to mutate a post part that wasn't present: " + message.info.identifier);
                }
            }, 100, !isServer, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartMutatedEvent, tile was not present"))));
        }

        public static class Packet {
            public final TilePartInfo info;
            public final CompoundTag data;
            public final String partMetaIdentifier;
            public final Optional<Vector3> offset;

            public Packet(TilePartInfo info, CompoundTag data, String partMetaIdentifier) {
                this(info, data, partMetaIdentifier, Optional.empty());
            }

            public Packet(TilePartInfo info, CompoundTag data, String partMetaIdentifier, Vector3 offset) {
                this(info, data, partMetaIdentifier, Optional.of(offset));
            }

            public Packet(TilePartInfo info, CompoundTag data, String partMetaIdentifier, Optional<Vector3> offset) {
                this.info = info;
                this.data = data;
                this.partMetaIdentifier = partMetaIdentifier;
                this.offset = offset;
            }
        }
    }

    public static class TilePartInfo {
        public final ResourceLocation dimensionKey;
        public final BlockPos pos;
        public final UUID identifier;
        public static final CompoundSerializable<TilePartInfo> Serializer = new SerializerImpl();

        public TilePartInfo(BlockEntity tile, UUID identifier) {
            this.dimensionKey = tile.m_58904_().m_46472_().m_135782_();
            this.pos = tile.m_58899_();
            this.identifier = identifier;
        }

        public TilePartInfo(ResourceLocation dimensionKey, BlockPos pos, UUID identifier) {
            this.dimensionKey = dimensionKey;
            this.pos = pos;
            this.identifier = identifier;
        }

        public static final class SerializerImpl
        implements CompoundSerializable<TilePartInfo> {
            @Override
            public CompoundTag write(TilePartInfo tilePartInfo, CompoundTag compound) {
                compound.m_128359_("Dimension", tilePartInfo.dimensionKey.toString());
                compound.m_128365_("Pos", (Tag)BlockPosSerializer.INSTANCE.write(tilePartInfo.pos, compound));
                compound.m_128362_("Id", tilePartInfo.identifier);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundTag compound) {
                return compound.m_128441_("Dimension") && compound.m_128441_("Pos") && compound.m_128441_("Id");
            }

            @Override
            public TilePartInfo read(CompoundTag compound) {
                return new TilePartInfo(new ResourceLocation(compound.m_128461_("Dimension")), BlockPosSerializer.INSTANCE.read(compound.m_128469_("Pos")), compound.m_128342_("Id"));
            }

            @Override
            public Class<TilePartInfo> getTargetClass() {
                return TilePartInfo.class;
            }

            @Override
            public void write(TilePartInfo tilePartInfo, FriendlyByteBuf buffer) {
                buffer.m_130085_(tilePartInfo.dimensionKey);
                BlockPosSerializer.INSTANCE.write(tilePartInfo.pos, buffer);
                buffer.m_130077_(tilePartInfo.identifier);
            }

            @Override
            public TilePartInfo read(FriendlyByteBuf buffer) {
                return new TilePartInfo(buffer.m_130281_(), BlockPosSerializer.INSTANCE.read(buffer), buffer.m_130259_());
            }
        }
    }

    public static class TraceResult {
        public final BlockPartInstance part;
        public final UUID id;
        public final Vector3 hitPos;
        public final Ray ray;

        public TraceResult(BlockPartInstance part, UUID id, Vector3 hitPos, Ray ray) {
            this.part = part;
            this.id = id;
            this.hitPos = hitPos;
            this.ray = ray;
        }
    }

    public static class PartRemovedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            TilePartInfo.Serializer.write(message.info, buffer);
            buffer.writeBoolean(message.shouldDropItem);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(TilePartInfo.Serializer.read(buffer), buffer.readBoolean());
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            boolean isClient = context.getDirection().getReceptionSide().isClient();
            TileEntityUtils.findWorld(message.info.dimensionKey, isClient).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(new WorldLocation(message.info.pos, (Level)level), PostTile.class, tile -> {
                BlockPartInstance oldPart = tile.removePart(message.info.identifier);
                if (oldPart != null && !tile.m_58904_().m_5776_() && !context.getSender().m_7500_() && message.shouldDropItem) {
                    for (ItemStack item : oldPart.blockPart.getDrops((PostTile)tile)) {
                        if (context.getSender().m_150109_().m_36054_(item) || !(tile.m_58904_() instanceof ServerLevel)) continue;
                        ServerLevel serverWorld = (ServerLevel)tile.m_58904_();
                        BlockPos pos = message.info.pos;
                        ItemEntity itementity = new ItemEntity((Level)serverWorld, (double)pos.m_123341_() + (double)serverWorld.m_5822_().nextFloat() * 0.5 + 0.25, (double)pos.m_123342_() + (double)serverWorld.m_5822_().nextFloat() * 0.5 + 0.25, (double)pos.m_123343_() + (double)serverWorld.m_5822_().nextFloat() * 0.5 + 0.25, item);
                        itementity.m_32060_();
                        serverWorld.m_7967_((Entity)itementity);
                    }
                }
            }, 100, isClient, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartRemovedEvent, tile was not present"))));
        }

        public static class Packet {
            public final TilePartInfo info;
            public final boolean shouldDropItem;

            public Packet(TilePartInfo info, boolean shouldDropItem) {
                this.info = info;
                this.shouldDropItem = shouldDropItem;
            }
        }
    }

    public static class PartAddedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            TilePartInfo.Serializer.write(message.info, buffer);
            StringSerializer.instance.write(message.partData.m_7916_(), buffer);
            StringSerializer.instance.write(message.partMetaIdentifier, buffer);
            Vector3.Serializer.write(message.offset, buffer);
            buffer.m_130055_(message.cost);
            PlayerHandle.Serializer.write(message.player, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            try {
                return new Packet(TilePartInfo.Serializer.read(buffer), TagParser.m_129359_((String)StringSerializer.instance.read(buffer)), StringSerializer.instance.read(buffer), Vector3.Serializer.read(buffer), buffer.m_130267_(), PlayerHandle.Serializer.read(buffer));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                throw new RuntimeException("An exception occurred in PostTile Packet Tag decoding");
            }
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            boolean isClientSide = context.getDirection().getReceptionSide().isClient();
            TileEntityUtils.findTileEntity(message.info.dimensionKey, isClientSide, message.info.pos, PostTile.class).ifPresent(tile -> {
                Optional<BlockPartMetadata> meta = partsMetadata.stream().filter(m -> m.identifier.equals(message.partMetaIdentifier)).findFirst();
                if (meta.isPresent()) {
                    tile.addPart(message.info.identifier, new BlockPartInstance((BlockPart)meta.get().read(message.partData), message.offset), message.cost, message.player);
                    if (message.cost.m_41613_() > 0 && (!isClientSide || SideUtils.getClientPlayer().map(player -> player.m_142081_().equals(message.player.id)).orElse(false).booleanValue())) {
                        SideUtils.makePlayerPayIfEditor(isClientSide, (Player)context.getSender(), message.player, message.cost);
                    }
                    tile.m_6596_();
                } else {
                    Signpost.LOGGER.warn("Could not find meta for part " + message.partMetaIdentifier);
                }
            });
        }

        public static class Packet {
            public final TilePartInfo info;
            public final String partMetaIdentifier;
            public final CompoundTag partData;
            public final Vector3 offset;
            public final ItemStack cost;
            public final PlayerHandle player;

            public Packet(TilePartInfo info, CompoundTag partData, String partMetaIdentifier, Vector3 offset, ItemStack cost, PlayerHandle player) {
                this.info = info;
                this.partMetaIdentifier = partMetaIdentifier;
                this.partData = partData;
                this.offset = offset;
                this.cost = cost;
                this.player = player;
            }
        }
    }
}

