/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.commands.WaystoneArgument;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.TextComponents;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class DiscoverWaystone {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"discover").requires(source -> source.m_6761_(((Integer)Config.Server.permissions.discoverPermissionLevel.get()).intValue()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"waystone", (ArgumentType)new WaystoneArgument()).requires(source -> {
            try {
                source.m_81375_();
                return true;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(context -> DiscoverWaystone.execute((String)context.getArgument("waystone", String.class), ((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"waystone", (ArgumentType)new WaystoneArgument()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> DiscoverWaystone.execute((String)context.getArgument("waystone", String.class), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
    }

    private static int execute(String name, ServerPlayer player) throws CommandSyntaxException {
        WaystoneHandle.Vanilla handle = WaystoneLibrary.getInstance().getHandleByName(name).orElseThrow(() -> new SimpleCommandExceptionType((Message)new TranslatableComponent("signpost.waystone_not_found", new Object[]{Colors.wrap(name, Colors.highlight)})).create());
        if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle((Entity)player), handle)) {
            player.m_6352_((Component)new TranslatableComponent("signpost.discovered", new Object[]{TextComponents.waystone(player, name)}), Util.f_137441_);
        }
        return 1;
    }
}

