/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.DropDownSelection;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DropDownSelection<EntryType>
extends ImageButton {
    public final Rect rect;
    private static final TextureResource texture = TextureResource.expandContract;
    public static final TextureSize size = new TextureSize(11, 11);
    private final Consumer<List> onShow;
    private final Consumer<List> onHide;
    private final Consumer<EntryType> onSelectionChanged;
    private final Font fontRenderer;
    private boolean isListVisible;
    private final List list;
    private final java.util.List<EntryType> allEntries = new ArrayList<EntryType>();
    private Predicate<EntryType> filter = b -> true;
    private int selectedIndex;
    private final boolean shouldHighlightSelected;

    public Collection<EntryType> getAllEntries() {
        return this.allEntries;
    }

    public Optional<EntryType> getSelectedEntry() {
        List.Entry selectedEntry = (List.Entry)this.list.m_93511_();
        if (selectedEntry == null) {
            return Optional.empty();
        }
        return Optional.of(selectedEntry.content);
    }

    public void setFilter(Predicate<EntryType> filter) {
        this.filter = filter;
        this.list.updateContent();
    }

    public DropDownSelection(Font fontRenderer, Point position, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged, boolean shouldHighlightSelected) {
        this(fontRenderer, new Rect(position, size, xAlignment, yAlignment), width, height, yOffset, onShow, onHide, onSelectionChanged, shouldHighlightSelected);
    }

    private DropDownSelection(Font fontRenderer, Rect rect, int width, int height, int yOffset, Consumer<List> onShow, Consumer<List> onHide, Consumer<EntryType> onSelectionChanged, boolean shouldHighlightSelected) {
        super(rect.point.x, rect.point.y, rect.width, rect.height, 0, 0, DropDownSelection.texture.size.height, DropDownSelection.texture.location, DropDownSelection.texture.fileSize.width, DropDownSelection.texture.fileSize.height, b -> ((DropDownSelection)b).toggle());
        this.rect = rect;
        this.fontRenderer = fontRenderer;
        this.shouldHighlightSelected = shouldHighlightSelected;
        this.list = new List(this, Minecraft.m_91087_(), new Point(rect.point.x + DropDownSelection.size.width, rect.point.y + DropDownSelection.size.height + yOffset), width, height);
        this.onSelectionChanged = onSelectionChanged;
        this.onShow = onShow;
        this.onHide = onHide;
    }

    public void addEntry(EntryType text) {
        if (!this.allEntries.contains(text)) {
            this.allEntries.add(text);
            this.list.updateContent();
        }
    }

    public void removeEntry(EntryType text) {
        if (this.allEntries.contains(text)) {
            this.allEntries.remove(text);
            this.list.updateContent();
        }
    }

    public void setEntries(Collection<EntryType> entries) {
        this.allEntries.clear();
        this.addEntries(entries);
    }

    public void addEntries(Collection<EntryType> entries) {
        this.allEntries.addAll(entries);
        this.list.updateContent();
    }

    public void toggle() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        } else {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void showList() {
        if (!this.isListVisible) {
            this.isListVisible = true;
            this.onShow.accept(this.list);
        }
    }

    public void hideList() {
        if (this.isListVisible) {
            this.isListVisible = false;
            this.onHide.accept(this.list);
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 100.0);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.isListVisible) {
            this.list.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        matrixStack.m_85849_();
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)DropDownSelection.texture.location);
        RenderSystem.m_69465_();
        int yTexStart = this.f_93622_ ? DropDownSelection.texture.size.height : 0;
        int xTexStart = this.isListVisible ? DropDownSelection.texture.size.width : 0;
        DropDownSelection.m_93143_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)100, (float)xTexStart, (float)yTexStart, (int)this.f_93618_, (int)this.f_93619_, (int)DropDownSelection.texture.fileSize.height, (int)DropDownSelection.texture.fileSize.width);
        RenderSystem.m_69482_();
    }

    public class List
    extends ObjectSelectionList<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
        private final int rimHeight;
        final /* synthetic */ DropDownSelection this$0;

        public List(DropDownSelection this$0, Minecraft minecraft, Point topRight, int width, int height) {
            Objects.requireNonNull(minecraft.f_91062_);
            this(this$0, minecraft, topRight, width, height, 9);
        }

        public List(DropDownSelection this$0, Minecraft minecraft, Point topRight, int width, int height, int rimHeight) {
            this.this$0 = this$0;
            super(minecraft, width, height, topRight.y + rimHeight, topRight.y + height - rimHeight, 14);
            this.f_93393_ = topRight.x - width;
            this.f_93392_ = topRight.x;
            this.m_93473_(false, 0);
            this.rimHeight = rimHeight;
            this.updateContent();
        }

        public void updateContent() {
            this.m_5988_(this.this$0.allEntries.stream().filter(this.this$0.filter).map(x$0 -> new Entry(x$0)).collect(Collectors.toList()));
            this.m_93410_(this.m_93517_());
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.m_7733_(matrixStack);
            int i = this.m_5756_();
            int j = i + 6;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureResource.background.location);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int backgroundBrightness = 170;
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(backgroundBrightness, backgroundBrightness, backgroundBrightness, 255).m_5752_();
            tesselator.m_85914_();
            int k = this.m_5747_();
            int l = this.f_93390_ + 4 - (int)this.m_93517_();
            this.m_93451_(matrixStack, k, l, mouseX, mouseY, partialTicks);
            RenderSystem.m_69465_();
            this.renderStripe(new Point(this.f_93393_ - 2, this.f_93390_ - this.rimHeight), new Point(this.f_93393_, this.f_93391_ + this.rimHeight));
            this.renderStripe(new Point(this.f_93393_, this.f_93390_ - this.rimHeight), new Point(this.f_93392_, this.f_93390_));
            this.renderStripe(new Point(this.f_93393_, this.f_93391_), new Point(this.f_93392_, this.f_93391_ + this.rimHeight));
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 4), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 4), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            tesselator.m_85914_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 4), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 4), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
            tesselator.m_85914_();
            int j1 = this.m_93518_();
            if (j1 > 0) {
                RenderSystem.m_69472_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                int k1 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
                k1 = Mth.m_14045_((int)k1, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
                int l1 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - k1) / j1 + this.f_93390_;
                if (l1 < this.f_93390_) {
                    l1 = this.f_93390_;
                }
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_5483_((double)i, (double)this.f_93391_, 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93391_, 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93390_, 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)this.f_93390_, 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                tesselator.m_85914_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_5483_((double)i, (double)(l1 + k1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)(l1 + k1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)l1, 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)l1, 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                tesselator.m_85914_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_5483_((double)i, (double)(l1 + k1 - 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)l1, 0.0).m_7421_(1.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)l1, 0.0).m_7421_(0.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
                tesselator.m_85914_();
            }
            this.m_7415_(matrixStack, mouseX, mouseY);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
        }

        protected void renderStripe(Point min, Point max) {
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureResource.background.location);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)min.x, (double)max.y, 0.0).m_7421_((float)min.x / 32.0f, (float)max.y / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_5483_((double)max.x, (double)max.y, 0.0).m_7421_((float)max.x / 32.0f, (float)max.y / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_5483_((double)max.x, (double)min.y, 0.0).m_7421_((float)max.x / 32.0f, (float)min.y / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_5483_((double)min.x, (double)min.y, 0.0).m_7421_((float)min.x / 32.0f, (float)min.y / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
            tessellator.m_85914_();
        }

        protected void m_93451_(PoseStack matrixStack, int p_renderList_1_, int p_renderList_2_, int mouseX, int mouseY, float p_renderList_5_) {
            int itemCount = this.m_5773_();
            for (int i = 0; i < itemCount; ++i) {
                int rowTop = this.m_7610_(i);
                Objects.requireNonNull(this.this$0.fontRenderer);
                int rowBottom = rowTop + 9;
                if (rowBottom < this.f_93390_ || rowTop > this.f_93391_) continue;
                int height = this.f_93387_ - 4;
                Entry e = (Entry)this.m_93500_(i);
                int width = this.m_5759_();
                int left = this.m_5747_();
                e.m_6311_(matrixStack, i, rowTop, left, width, height, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && Objects.equals(this.m_93412_(mouseX, mouseY), (Object)e), p_renderList_5_);
            }
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        public class Entry
        extends ObjectSelectionList.Entry<gollorum.signpost.minecraft.gui.widgets.DropDownSelection$List.Entry> {
            private final EntryType content;

            public Entry(EntryType content) {
                this.content = content;
            }

            public void m_6311_(PoseStack matrixStack, int i, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
                int brightness = 255;
                if (this.m_5953_(mouseX, mouseY)) {
                    brightness = (int)((float)brightness * 0.8f);
                }
                if (List.this.this$0.shouldHighlightSelected && List.this.this$0.allEntries.indexOf(((Entry)((List)List.this).m_93500_((int)i)).content) == List.this.this$0.selectedIndex) {
                    brightness = (int)((float)brightness * 0.6f);
                }
                RenderingUtil.drawString(List.this.this$0.fontRenderer, this.content.toString(), new Point(List.this.f_93393_, p_render_2_ + 1), Rect.XAlignment.Center, Rect.YAlignment.Top, Colors.from(brightness, brightness, brightness), List.this.f_93388_ - 6, true);
            }

            public Component m_142172_() {
                return new TextComponent("");
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                List.this.this$0.selectedIndex = List.this.this$0.allEntries.indexOf(this.content);
                List.this.this$0.onSelectionChanged.accept(this.content);
                return true;
            }
        }
    }
}

