/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.registry;

import gollorum.signpost.minecraft.block.PostBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="signpost", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ColorRegistry {
    private static final BlockColor overlayBlockColor = (blockState, world, blockPos, tintIndex) -> ColorRegistry.getOverlayColor(tintIndex, world, blockPos);
    private static final ItemColor overlayItemColor = (itemStack, tintIndex) -> {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (world == null || player == null) {
            return -1;
        }
        return ColorRegistry.getOverlayColor(tintIndex, (BlockAndTintGetter)world, player.m_142538_());
    };

    @SubscribeEvent
    static void onBlockColor(ColorHandlerEvent.Block event) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            event.getBlockColors().m_92589_(overlayBlockColor, new Block[]{variant.getBlock()});
        }
    }

    @SubscribeEvent
    static void onItemColor(ColorHandlerEvent.Item event) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            event.getItemColors().m_92689_(overlayItemColor, new ItemLike[]{variant.getBlock()});
            event.getBlockColors().m_92589_(overlayBlockColor, new Block[]{variant.getBlock()});
        }
    }

    public static int getOverlayColor(int tintIndex, BlockAndTintGetter world, BlockPos pos) {
        if (world == null || pos == null) {
            return -1;
        }
        return switch (tintIndex) {
            case 1 -> BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos);
            case 2 -> BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos);
            case 3 -> BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos);
            default -> -1;
        };
    }
}

