/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public interface EventDispatcher<Event> {
    public boolean addListener(@Nonnull Consumer<Event> var1);

    public boolean removeListener(@Nonnull Consumer<Event> var1);

    public static abstract class Impl<Event>
    implements EventDispatcher<Event> {
        protected final Set<Consumer<Event>> listeners = new HashSet<Consumer<Event>>();

        @Override
        public boolean addListener(@Nonnull Consumer<Event> listener) {
            return this.listeners.add(listener);
        }

        @Override
        public boolean removeListener(@Nonnull Consumer<Event> listener) {
            return this.listeners.remove(listener);
        }

        protected void dispatch(Event event) {
            this.dispatch(event, new HashSet<Consumer<Event>>(this.listeners));
        }

        protected void dispatch(Event event, Set<Consumer<Event>> listeners) {
            listeners.forEach(listener -> listener.accept(event));
        }

        public static class WithPublicDispatch<Event>
        extends Impl<Event> {
            public void dispatch(Event event, boolean clearAfterwards) {
                HashSet copyOfListeners = new HashSet(this.listeners);
                if (clearAfterwards) {
                    this.clear();
                }
                super.dispatch(event, copyOfListeners);
            }

            public void clear() {
                this.listeners.clear();
            }
        }
    }
}

