/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import com.google.common.collect.Lists;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.worldgen.DefaultVillageNamesProvider;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public interface VillageNamesProvider {
    public static final List<VillageNamesProvider> activeProviders = Lists.newArrayList((Object[])new VillageNamesProvider[]{new DefaultVillageNamesProvider()});

    public static Optional<String> requestFor(BlockPos blockPos, BlockPos villagePos, ServerLevel world, Random random) {
        Set<String> allTakenNames = WaystoneLibrary.getInstance().getAllWaystoneNames(false).get();
        for (VillageNamesProvider provider : activeProviders) {
            Optional<String> name = provider.getFor(blockPos, villagePos, world, n -> !allTakenNames.contains(n), random);
            if (!name.isPresent()) continue;
            return name;
        }
        return Optional.empty();
    }

    public Optional<String> getFor(BlockPos var1, BlockPos var2, ServerLevel var3, Predicate<String> var4, Random var5);
}

