/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.client;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.nick.chimes.client.settings.Animated;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ChimesSettings {
    private static final ChimesSettings INSTANCE;
    public static ForgeConfigSpec SPEC;
    private static final Path CONFIG_PATH;
    private final ForgeConfigSpec.EnumValue<Animated> currentAnimated;

    private ChimesSettings(ForgeConfigSpec.Builder configSpecBuilder) {
        this.currentAnimated = configSpecBuilder.translation("chimes.configGui.options.animated").defineEnum("currentAnimated", (Enum)Animated.ANIMATED);
    }

    public static ChimesSettings getInstance() {
        return INSTANCE;
    }

    public Animated currentAnimated() {
        return (Animated)((Object)this.currentAnimated.get());
    }

    public void changeCurrentAnimated(Animated newValue) {
        Objects.requireNonNull(newValue, "newValue");
        this.currentAnimated.set((Object)newValue);
    }

    public void save() {
        SPEC.save();
    }

    static {
        CONFIG_PATH = Paths.get("config", "chimes.toml");
        Pair specPair = new ForgeConfigSpec.Builder().configure(ChimesSettings::new);
        INSTANCE = (ChimesSettings)specPair.getLeft();
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().autoreload().writingMode(WritingMode.REPLACE).build();
        config.load();
        config.save();
        SPEC.setConfig((CommentedConfig)config);
    }
}

