/*
 * Decompiled with CFR 0.152.
 */
package bloop.excavation.event;

import bloop.excavation.Excavation;
import bloop.excavation.config.Tags;
import bloop.excavation.veinmine.MiningAlgorithm;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="excavation")
public class ServerEvent {
    private static boolean alreadyBreaking = false;
    public static Set<UUID> playersWithButtonDown = new HashSet<UUID>();

    @SubscribeEvent
    public static void veinMine(BlockEvent.BreakEvent e) {
        boolean blockIsAllowed;
        boolean correctTool;
        Player player = e.getPlayer();
        Level level = e.getPlayer().f_19853_;
        BlockPos blockPos = e.getPos();
        Block block = level.m_8055_(blockPos).m_60734_();
        if (player.m_36324_().m_38702_() == 0) {
            return;
        }
        if (alreadyBreaking) {
            return;
        }
        if (player instanceof FakePlayer) {
            return;
        }
        if (Excavation.config.crouchEnable.get().booleanValue()) {
            if (!player.m_6047_()) {
                ServerEvent.removePlayer(player.m_142081_());
                return;
            }
            ServerEvent.addPlayer(player.m_142081_());
        }
        if (!(correctTool = ForgeHooks.isCorrectToolForDrops((BlockState)level.m_8055_(blockPos), (Player)player)) && Excavation.config.mineWithTool.get().booleanValue() && !player.m_7500_()) {
            return;
        }
        if (!level.m_8055_(blockPos).m_60734_().canHarvestBlock(level.m_8055_(blockPos), (BlockGetter)level, blockPos, player) && !player.m_7500_() || !level.m_46749_(blockPos)) {
            return;
        }
        boolean bl = blockIsAllowed = !block.m_204297_().m_203656_(Tags.blacklist) && Registry.f_122824_.m_203431_(Tags.whitelist).map(tag -> tag.m_203632_() == 0 || tag.m_203333_((Holder)block.m_204297_())).orElse(false) != false;
        if (!blockIsAllowed) {
            return;
        }
        if (playersWithButtonDown.contains(player.m_142081_())) {
            alreadyBreaking = true;
            e.setCanceled(true);
            MiningAlgorithm miningAlgorithm = new MiningAlgorithm(blockPos, level, player);
            miningAlgorithm.findBlocks();
            miningAlgorithm.mine();
            ServerEvent.setAlreadyBreaking(false);
        }
    }

    public static void setAlreadyBreaking(boolean breaking) {
        alreadyBreaking = breaking;
    }

    public static void addPlayer(UUID uuid) {
        playersWithButtonDown.add(uuid);
    }

    public static void removePlayer(UUID uuid) {
        playersWithButtonDown.removeIf(u -> u.equals(uuid));
    }
}

