/*
 * Decompiled with CFR 0.152.
 */
package bloop.excavation.veinmine;

import bloop.excavation.Excavation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;

public class MiningAlgorithm {
    private final List<BlockPos> blocksToBreak = new ArrayList<BlockPos>();
    private final BlockPos startingBlock;
    private final List<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
    private final Level level;
    private final ServerPlayer player;
    private int totalXp = 0;
    private final BlockPos playerPos;
    private final List<ItemStack> itemsToDrop = new ArrayList<ItemStack>();

    public MiningAlgorithm(BlockPos start, Level level, Player playerIn) {
        this.level = level;
        this.player = (ServerPlayer)playerIn;
        this.playerPos = new BlockPos(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
        this.startingBlock = start;
        this.blocksToBreak.add(start);
        this.alreadyChecked.add(start);
        this.itemsToDrop.add(ItemStack.f_41583_);
    }

    public void findBlocks() {
        BlockPos.MutableBlockPos checking = new BlockPos.MutableBlockPos();
        int[] range = new int[]{0, -1, 1};
        ArrayList<BlockPos> dummyBlocks = new ArrayList<BlockPos>();
        while (!this.blocksToBreak.equals(dummyBlocks)) {
            dummyBlocks.clear();
            dummyBlocks.addAll(this.blocksToBreak);
            for (BlockPos p2 : dummyBlocks) {
                for (int x : range) {
                    for (int y : range) {
                        for (int z : range) {
                            checking.m_122190_((Vec3i)p2).m_122184_(x, y, z);
                            if (this.alreadyChecked.contains(checking)) continue;
                            this.blocksToBreak.add(checking.m_7949_());
                            this.alreadyChecked.add(checking.m_7949_());
                        }
                    }
                }
            }
            dummyBlocks.clear();
            dummyBlocks.addAll(this.blocksToBreak);
            this.blocksToBreak.removeIf(p -> !this.level.m_8055_(this.startingBlock).m_60734_().equals(this.level.m_8055_(p).m_60734_()));
            if (this.blocksToBreak.size() < Excavation.config.maxBlocks.get()) continue;
            this.blocksToBreak.subList(Excavation.config.maxBlocks.get(), this.blocksToBreak.size()).clear();
            break;
        }
    }

    public boolean tryBreak(BlockPos p) {
        BlockState state = this.level.m_8055_(p);
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_) {
            return false;
        }
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)this.player) && !this.player.m_7500_()) {
            return false;
        }
        if (!this.level.m_5776_()) {
            int xp = ForgeHooks.onBlockBreakEvent((Level)this.level, (GameType)this.player.f_8941_.m_9290_(), (ServerPlayer)this.player, (BlockPos)p);
            if (xp == -1) {
                return false;
            }
            if (!block.onDestroyedByPlayer(state, this.level, p, (Player)this.player, !this.player.m_7500_(), state.m_60819_())) {
                return false;
            }
            if (!this.player.m_7500_()) {
                if (!Excavation.config.vacuumBlocks.get().booleanValue()) {
                    block.m_6240_(this.level, (Player)this.player, p, state, this.level.m_7702_(p), this.player.m_21205_());
                    this.player.m_36399_((float)((double)0.005f * Excavation.config.exhaustionMultiplier.get()) - 0.005f);
                } else {
                    this.addToDropsList(p, block, state);
                    this.player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
                    this.player.m_36399_((float)((double)0.005f * Excavation.config.exhaustionMultiplier.get()));
                }
                if (xp > 0) {
                    this.totalXp += xp;
                }
            }
        } else {
            if (!block.onDestroyedByPlayer(state, this.level, p, (Player)this.player, !this.player.m_7500_(), state.m_60819_())) {
                return false;
            }
            block.m_6240_(this.level, (Player)this.player, p, state, this.level.m_7702_(p), this.player.m_21205_());
        }
        return true;
    }

    private void addToDropsList(BlockPos p, Block block, BlockState state) {
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.level), (BlockPos)p, (BlockEntity)this.level.m_7702_(p), (Entity)this.player, (ItemStack)this.player.m_21205_());
        ArrayList dummyItemsToDrop = new ArrayList();
        this.itemsToDrop.forEach(i -> dummyItemsToDrop.add(i.m_41720_()));
        for (ItemStack drop : drops) {
            if (dummyItemsToDrop.contains(drop.m_41720_())) {
                int oldCount = this.itemsToDrop.get(dummyItemsToDrop.indexOf(drop.m_41720_())).m_41613_();
                int extraCount = drop.m_41613_();
                this.itemsToDrop.get(dummyItemsToDrop.indexOf(drop.m_41720_())).m_41764_(oldCount + extraCount);
                continue;
            }
            this.itemsToDrop.add(drop);
        }
        this.itemsToDrop.remove(ItemStack.f_41583_);
    }

    public void dropItems() {
        if (!this.level.m_5776_() && this.level.m_46469_().m_46207_(GameRules.f_46136_) && !this.level.restoringBlockSnapshots) {
            for (ItemStack item : this.itemsToDrop) {
                if (this.player.m_150109_().m_36054_(item)) continue;
                ItemEntity itemEntity = new ItemEntity(this.level, (double)this.playerPos.m_123341_() + 0.5, (double)this.playerPos.m_123342_() + 0.5, (double)this.playerPos.m_123343_() + 0.5, item);
                itemEntity.m_32060_();
                this.level.m_7967_((Entity)itemEntity);
            }
        }
        this.itemsToDrop.clear();
    }

    public void mine() {
        this.totalXp = 0;
        for (BlockPos p : this.blocksToBreak) {
            ItemStack mh;
            if (!this.tryBreak(p) || this.level.m_5776_() || !(mh = this.player.m_21205_()).m_41763_() || this.player.m_7500_()) continue;
            if (mh.m_41773_() < mh.m_41776_()) {
                mh.m_41629_(1, this.player.m_21187_(), this.player);
                continue;
            }
            mh.m_41622_(1, (LivingEntity)this.player, player -> player.m_21166_(EquipmentSlot.MAINHAND));
            break;
        }
        if (!this.level.m_5776_()) {
            this.dropItems();
        }
        this.level.m_8055_(this.startingBlock).m_60734_().m_49805_((ServerLevel)this.level, this.playerPos, this.totalXp);
    }
}

