/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AppEng;
import appeng.core.AppEngClient;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class MolecularAssemblerRenderer
implements BlockEntityRenderer<MolecularAssemblerBlockEntity> {
    public static final ResourceLocation LIGHTS_MODEL = AppEng.makeId("block/molecular_assembler_lights");
    private final Random particleRandom = new Random();

    public MolecularAssemblerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MolecularAssemblerBlockEntity molecularAssembler, float partialTicks, PoseStack ms, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        AssemblerAnimationStatus status = molecularAssembler.getAnimationStatus();
        if (status != null) {
            if (!Minecraft.m_91087_().m_91104_()) {
                if (status.isExpired()) {
                    molecularAssembler.setAnimationStatus(null);
                }
                status.setAccumulatedTicks(status.getAccumulatedTicks() + partialTicks);
                status.setTicksUntilParticles(status.getTicksUntilParticles() - partialTicks);
            }
            this.renderStatus(molecularAssembler, ms, bufferIn, combinedLightIn, status);
        }
        if (molecularAssembler.isPowered()) {
            this.renderPowerLight(ms, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderPowerLight(PoseStack ms, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel lightsModel = minecraft.m_91304_().getModel(LIGHTS_MODEL);
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110503_());
        minecraft.m_91289_().m_110937_().renderModel(ms.m_85850_(), buffer, null, lightsModel, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    private void renderStatus(MolecularAssemblerBlockEntity molecularAssembler, PoseStack ms, MultiBufferSource bufferIn, int combinedLightIn, AssemblerAnimationStatus status) {
        double centerX = (float)molecularAssembler.m_58899_().m_123341_() + 0.5f;
        double centerY = (float)molecularAssembler.m_58899_().m_123342_() + 0.5f;
        double centerZ = (float)molecularAssembler.m_58899_().m_123343_() + 0.5f;
        Minecraft minecraft = Minecraft.m_91087_();
        if (status.getTicksUntilParticles() <= 0.0f) {
            status.setTicksUntilParticles(4.0f);
            if (AppEngClient.instance().shouldAddParticles(this.particleRandom)) {
                for (int x = 0; x < (int)Math.ceil((double)status.getSpeed() / 5.0); ++x) {
                    minecraft.f_91061_.m_107370_((ParticleOptions)ParticleTypes.CRAFTING, centerX, centerY, centerZ, 0.0, 0.0, 0.0);
                }
            }
        }
        ItemStack is = status.getIs();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.5);
        if (!(is.m_41720_() instanceof BlockItem)) {
            ms.m_85837_(0.0, (double)-0.3f, 0.0);
        } else {
            ms.m_85837_(0.0, (double)-0.2f, 0.0);
        }
        itemRenderer.m_174269_(is, ItemTransforms.TransformType.GROUND, combinedLightIn, OverlayTexture.f_118083_, ms, bufferIn, 0);
        ms.m_85849_();
    }
}

