/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.recipes;

import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.datagen.providers.recipes.AE2RecipeProvider;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class InscriberRecipes
extends AE2RecipeProvider {
    public InscriberRecipes(DataGenerator generator) {
        super(generator);
    }

    @Override
    protected void buildAE2CraftingRecipes(Consumer<FinishedRecipe> consumer) {
        this.inscribe((ItemLike)Items.f_41913_, AEItems.SILICON_PRESS.stack()).setTop(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.SILICON_PRESS})).setMode(InscriberProcessType.INSCRIBE).save(consumer, "silicon_press");
        this.inscribe(Ingredient.m_204132_(ConventionTags.SILICON), AEItems.SILICON_PRINT.stack()).setTop(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.SILICON_PRESS})).setMode(InscriberProcessType.INSCRIBE).save(consumer, "silicon_print");
        this.processor(consumer, "calculation_processor", AEItems.CALCULATION_PROCESSOR_PRESS, AEItems.CALCULATION_PROCESSOR_PRINT, AEItems.CALCULATION_PROCESSOR, Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.CERTUS_QUARTZ_CRYSTAL}));
        this.processor(consumer, "engineering_processor", AEItems.ENGINEERING_PROCESSOR_PRESS, AEItems.ENGINEERING_PROCESSOR_PRINT, AEItems.ENGINEERING_PROCESSOR, Ingredient.m_204132_(ConventionTags.DIAMOND));
        this.processor(consumer, "logic_processor", AEItems.LOGIC_PROCESSOR_PRESS, AEItems.LOGIC_PROCESSOR_PRINT, AEItems.LOGIC_PROCESSOR, Ingredient.m_204132_(ConventionTags.GOLD_INGOT));
        this.inscribe(Ingredient.m_204132_(ConventionTags.FLUIX_CRYSTAL), AEItems.FLUIX_DUST.stack()).setMode(InscriberProcessType.INSCRIBE).save(consumer, "fluix_dust");
        this.inscribe(Ingredient.m_204132_(ConventionTags.CERTUS_QUARTZ), AEItems.CERTUS_QUARTZ_DUST.stack()).setMode(InscriberProcessType.INSCRIBE).save(consumer, "certus_quartz_dust");
    }

    private void processor(Consumer<FinishedRecipe> consumer, String name, ItemLike press, ItemLike print, ItemLike processor, Ingredient printMaterial) {
        this.inscribe(printMaterial, new ItemStack(print)).setTop(Ingredient.m_43929_((ItemLike[])new ItemLike[]{press})).setMode(InscriberProcessType.INSCRIBE).save(consumer, name + "_print");
        this.inscribe((ItemLike)Items.f_42451_, new ItemStack(processor)).setTop(Ingredient.m_43929_((ItemLike[])new ItemLike[]{print})).setBottom(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.SILICON_PRINT})).setMode(InscriberProcessType.PRESS).save(consumer, name);
        this.inscribe((ItemLike)Items.f_41913_, new ItemStack(press)).setTop(Ingredient.m_43929_((ItemLike[])new ItemLike[]{press})).setMode(InscriberProcessType.INSCRIBE).save(consumer, name + "_press");
    }

    private InscriberRecipeBuilder inscribe(ItemLike middle, ItemStack output) {
        return new InscriberRecipeBuilder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{middle}), output);
    }

    private InscriberRecipeBuilder inscribe(Ingredient middle, ItemStack output) {
        return new InscriberRecipeBuilder(middle, output);
    }

    static class InscriberRecipeBuilder {
        private final Ingredient middleInput;
        private Ingredient topOptional;
        private Ingredient bottomOptional;
        private final ItemStack output;
        private InscriberProcessType mode = InscriberProcessType.INSCRIBE;

        public InscriberRecipeBuilder(Ingredient middleInput, ItemStack output) {
            this.middleInput = middleInput;
            this.output = output;
        }

        public InscriberRecipeBuilder setTop(Ingredient topOptional) {
            this.topOptional = topOptional;
            return this;
        }

        public InscriberRecipeBuilder setBottom(Ingredient bottomOptional) {
            this.bottomOptional = bottomOptional;
            return this;
        }

        public InscriberRecipeBuilder setMode(InscriberProcessType processType) {
            this.mode = processType;
            return this;
        }

        public void save(Consumer<FinishedRecipe> consumer, String name) {
            consumer.accept(new Result(name));
        }

        class Result
        implements FinishedRecipe {
            private final String name;

            public Result(String name) {
                this.name = name;
            }

            public void m_7917_(JsonObject json) {
                json.addProperty("mode", InscriberRecipeBuilder.this.mode.name().toLowerCase(Locale.ROOT));
                json.add("result", (JsonElement)AE2RecipeProvider.toJson(InscriberRecipeBuilder.this.output));
                JsonObject ingredients = new JsonObject();
                ingredients.add("middle", InscriberRecipeBuilder.this.middleInput.m_43942_());
                if (InscriberRecipeBuilder.this.topOptional != null) {
                    ingredients.add("top", InscriberRecipeBuilder.this.topOptional.m_43942_());
                }
                if (InscriberRecipeBuilder.this.bottomOptional != null) {
                    ingredients.add("bottom", InscriberRecipeBuilder.this.bottomOptional.m_43942_());
                }
                json.add("ingredients", (JsonElement)ingredients);
            }

            public ResourceLocation m_6445_() {
                return AppEng.makeId("inscriber/" + this.name);
            }

            public RecipeSerializer<?> m_6637_() {
                return InscriberRecipeSerializer.INSTANCE;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }
    }
}

