/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks.ticking;

import appeng.api.networking.IGridNode;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.crafting.CraftingCalculation;
import appeng.hooks.ticking.ServerBlockEntityRepo;
import appeng.hooks.ticking.ServerGridRepo;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.util.ILevelRunnable;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.LogicalSide;

public class TickHandler {
    private static final int TIME_LIMIT_PROCESS_QUEUE_MILLISECONDS = 25;
    private static final TickHandler INSTANCE = new TickHandler();
    private final Queue<ILevelRunnable> serverQueue = new ArrayDeque<ILevelRunnable>();
    private final Multimap<LevelAccessor, CraftingCalculation> craftingJobs = LinkedListMultimap.create();
    private final Map<LevelAccessor, Queue<ILevelRunnable>> callQueue = new HashMap<LevelAccessor, Queue<ILevelRunnable>>();
    private final ServerBlockEntityRepo blockEntities = new ServerBlockEntityRepo();
    private final ServerGridRepo grids = new ServerGridRepo();
    private final Stopwatch stopWatch = Stopwatch.createUnstarted();
    private int processQueueElementsProcessed = 0;
    private int processQueueElementsRemaining = 0;
    private long tickCounter;

    public static TickHandler instance() {
        return INSTANCE;
    }

    private TickHandler() {
    }

    public void init() {
        MinecraftForge.EVENT_BUS.addListener(this::onServerTick);
        MinecraftForge.EVENT_BUS.addListener(this::onLevelTick);
        MinecraftForge.EVENT_BUS.addListener(this::onUnloadChunk);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onUnloadLevel);
    }

    public void addCallable(LevelAccessor level, Runnable c) {
        this.addCallable(level, (Level ignored) -> c.run());
    }

    public void addCallable(LevelAccessor level, ILevelRunnable c) {
        Preconditions.checkArgument((level == null || !level.m_5776_() ? 1 : 0) != 0, (Object)"Can only register serverside callbacks");
        if (level == null) {
            this.serverQueue.add(c);
        } else {
            Queue<ILevelRunnable> queue = this.callQueue.get(level);
            if (queue == null) {
                queue = new ArrayDeque<ILevelRunnable>();
                this.callQueue.put(level, queue);
            }
            queue.add(c);
        }
    }

    public void addInit(AEBaseBlockEntity blockEntity) {
        if (!blockEntity.m_58904_().m_5776_()) {
            Objects.requireNonNull(blockEntity);
            blockEntity.setQueuedForReady((byte)(blockEntity.getQueuedForReady() + 1));
            this.blockEntities.addBlockEntity(blockEntity);
        }
    }

    public void addNetwork(Grid grid) {
        Platform.assertServerThread();
        this.grids.addNetwork(grid);
    }

    public void removeNetwork(Grid grid) {
        Platform.assertServerThread();
        this.grids.removeNetwork(grid);
    }

    public Iterable<Grid> getGridList() {
        Platform.assertServerThread();
        return this.grids.getNetworks();
    }

    public void shutdown() {
        Platform.assertServerThread();
        this.blockEntities.clear();
        this.grids.clear();
    }

    public void onUnloadChunk(ChunkEvent.Unload ev) {
        LevelAccessor level = ev.getWorld();
        ChunkAccess chunk = ev.getChunk();
        if (!level.m_5776_()) {
            this.blockEntities.removeChunk(level, chunk.m_7697_().m_45588_());
        }
    }

    public void onUnloadLevel(WorldEvent.Unload ev) {
        LevelAccessor level = ev.getWorld();
        if (level.m_5776_()) {
            return;
        }
        ArrayList<GridNode> toDestroy = new ArrayList<GridNode>();
        this.grids.updateNetworks();
        for (Grid g : this.grids.getNetworks()) {
            for (IGridNode n : g.getNodes()) {
                if (n.getLevel() != level) continue;
                toDestroy.add((GridNode)n);
            }
        }
        for (GridNode n : toDestroy) {
            n.destroy();
        }
        this.blockEntities.removeLevel(level);
        this.callQueue.remove(level);
    }

    public void onLevelTick(TickEvent.WorldTickEvent ev) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                Level level = ev.world;
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (ev.side == LogicalSide.SERVER) break block7;
            }
            return;
        }
        if (ev.phase == TickEvent.Phase.START) {
            this.onServerLevelTickStart(serverLevel);
        } else if (ev.phase == TickEvent.Phase.END) {
            this.onServerLevelTickEnd(serverLevel);
        }
    }

    private void onServerLevelTickStart(ServerLevel level) {
        Queue<ILevelRunnable> queue = this.callQueue.remove(level);
        this.processQueueElementsRemaining += this.processQueue(queue, (Level)level);
        Queue<ILevelRunnable> newQueue = this.callQueue.put((LevelAccessor)level, queue);
        if (newQueue != null) {
            queue.addAll(newQueue);
        }
        this.grids.updateNetworks();
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onLevelStartTick((Level)level);
            }
            catch (Throwable t) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Ticking grid on start of level tick");
                g.fillCrashReportCategory(crashReport.m_127514_("Grid being ticked"));
                level.m_6026_(crashReport);
                throw new ReportedException(crashReport);
            }
        }
    }

    private void onServerLevelTickEnd(ServerLevel level) {
        this.simulateCraftingJobs((LevelAccessor)level);
        this.readyBlockEntities(level);
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onLevelEndTick((Level)level);
            }
            catch (Throwable t) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Ticking grid on end of level tick");
                g.fillCrashReportCategory(crashReport.m_127514_("Grid being ticked"));
                level.m_6026_(crashReport);
                throw new ReportedException(crashReport);
            }
        }
    }

    public void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            this.onServerTickStart();
        } else if (ev.phase == TickEvent.Phase.END) {
            this.onServerTickEnd();
        }
    }

    private void onServerTickStart() {
        this.processQueueElementsProcessed = 0;
        this.processQueueElementsRemaining = 0;
        this.stopWatch.reset();
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onServerStartTick();
            }
            catch (Throwable t) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Ticking grid on start of server tick");
                g.fillCrashReportCategory(crashReport.m_127514_("Grid being ticked"));
                throw new ReportedException(crashReport);
            }
        }
    }

    private void onServerTickEnd() {
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onServerEndTick();
            }
            catch (Throwable t) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Ticking grid on end of server tick");
                g.fillCrashReportCategory(crashReport.m_127514_("Grid being ticked"));
                throw new ReportedException(crashReport);
            }
        }
        this.processQueueElementsRemaining += this.processQueue(this.serverQueue, null);
        if (this.stopWatch.elapsed(TimeUnit.MILLISECONDS) > 25L) {
            AELog.warn("Exceeded time limit of %d ms after processing %d queued tick callbacks (%d remain)", 25, this.processQueueElementsProcessed, this.processQueueElementsRemaining);
        }
        ++this.tickCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(Level level, CraftingCalculation craftingCalculation) {
        Preconditions.checkArgument((!level.f_46443_ ? 1 : 0) != 0, (Object)"Trying to register a crafting job for a client-level");
        Multimap<LevelAccessor, CraftingCalculation> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)level, (Object)craftingCalculation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulateCraftingJobs(LevelAccessor level) {
        Multimap<LevelAccessor, CraftingCalculation> multimap = this.craftingJobs;
        synchronized (multimap) {
            Collection jobSet = this.craftingJobs.get((Object)level);
            if (!jobSet.isEmpty()) {
                int jobSize = jobSet.size();
                int microSecondsPerTick = AEConfig.instance().getCraftingCalculationTimePerTick() * 1000;
                int simTime = Math.max(1, microSecondsPerTick / jobSize);
                Iterator i = jobSet.iterator();
                while (i.hasNext()) {
                    CraftingCalculation cj = (CraftingCalculation)i.next();
                    if (cj.simulateFor(simTime)) continue;
                    i.remove();
                }
            }
        }
    }

    private void readyBlockEntities(ServerLevel level) {
        long[] workSet;
        Long2ObjectMap<List<AEBaseBlockEntity>> levelQueue = this.blockEntities.getBlockEntities((LevelAccessor)level);
        if (levelQueue == null) {
            return;
        }
        for (long packedChunkPos : workSet = levelQueue.keySet().toLongArray()) {
            if (!level.m_183438_(packedChunkPos)) continue;
            List chunkQueue = (List)levelQueue.remove(packedChunkPos);
            if (chunkQueue == null) {
                AELog.warn("Chunk %s was unloaded while we were readying block entities", new ChunkPos(packedChunkPos));
                continue;
            }
            for (AEBaseBlockEntity bt : chunkQueue) {
                if (bt.m_58901_()) continue;
                try {
                    bt.onReady();
                    bt.setReadyInvoked((byte)(bt.getReadyInvoked() + 1));
                }
                catch (Throwable t) {
                    CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Readying AE2 block entity");
                    bt.m_58886_(crashReport.m_127514_("Block entity being readied"));
                    throw new ReportedException(crashReport);
                }
            }
        }
    }

    private int processQueue(Queue<ILevelRunnable> queue, Level level) {
        if (queue == null) {
            return 0;
        }
        this.stopWatch.start();
        while (!queue.isEmpty()) {
            try {
                queue.poll().call(level);
                ++this.processQueueElementsProcessed;
                if (this.stopWatch.elapsed(TimeUnit.MILLISECONDS) <= 25L) continue;
                break;
            }
            catch (Exception e) {
                AELog.warn(e);
            }
        }
        this.stopWatch.stop();
        return queue.size();
    }

    public long getCurrentTick() {
        return this.tickCounter;
    }

    public List<Component> getBlockEntityReport() {
        return this.blockEntities.getReport();
    }
}

