/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.core.AELog;
import appeng.core.sync.packets.InterfaceTerminalPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.parts.crafting.PatternProviderPart;
import appeng.parts.reporting.PatternAccessTerminalPart;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class InterfaceTerminalMenu
extends AEBaseMenu {
    public static final MenuType<InterfaceTerminalMenu> TYPE = MenuTypeBuilder.create(InterfaceTerminalMenu::new, PatternAccessTerminalPart.class).requirePermission(SecurityPermissions.BUILD).build("interfaceterminal");
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<PatternProviderLogicHost, InvTracker> diList = new IdentityHashMap<PatternProviderLogicHost, InvTracker>();
    private final Long2ObjectOpenHashMap<InvTracker> byId = new Long2ObjectOpenHashMap();

    public InterfaceTerminalMenu(int id, Inventory ip, PatternAccessTerminalPart anchor) {
        this(TYPE, id, ip, anchor, true);
    }

    public InterfaceTerminalMenu(MenuType<?> menuType, int id, Inventory ip, Object host, boolean bindInventory) {
        super(menuType, id, ip, host);
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
    }

    @Override
    public void m_38946_() {
        if (this.isClientSide()) {
            return;
        }
        super.m_38946_();
        IGrid grid = this.getGrid();
        VisitorState state = new VisitorState();
        if (grid != null) {
            this.visitInterfaceHosts(grid, PatternProviderBlockEntity.class, state);
            this.visitInterfaceHosts(grid, PatternProviderPart.class, state);
        }
        if (state.total != this.diList.size() || state.forceFullUpdate) {
            this.sendFullUpdate(grid);
        } else {
            this.sendIncrementalUpdate();
        }
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private <T extends PatternProviderLogicHost> void visitInterfaceHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (PatternProviderLogicHost ih : grid.getActiveMachines(machineClass)) {
            PatternProviderLogic dual = ih.getLogic();
            if (dual.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL) == YesNo.NO) continue;
            InvTracker t = this.diList.get(ih);
            if (t == null || !t.name.equals(dual.getTermName())) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    @Override
    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        InvTracker inv = (InvTracker)this.byId.get(id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn("Client refers to invalid slot %d of inventory %s", slot, inv.name.getString());
            return;
        }
        ItemStack is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory interfaceSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), new PatternSlotFilter());
        ItemStack carried = this.m_142621_();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.m_41619_()) {
                    ItemStack inSlot = interfaceSlot.getStackInSlot(0);
                    if (inSlot.m_41619_()) {
                        this.m_142503_(interfaceSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.m_41777_();
                    ItemStack inHand = carried.m_41777_();
                    interfaceSlot.setItemDirect(0, ItemStack.f_41583_);
                    this.m_142503_(ItemStack.f_41583_);
                    this.m_142503_(interfaceSlot.addItems(inHand.m_41777_()));
                    if (carried.m_41619_()) {
                        this.m_142503_(inSlot);
                        break;
                    }
                    this.m_142503_(inHand);
                    interfaceSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.m_142503_(interfaceSlot.getStackInSlot(0));
                interfaceSlot.setItemDirect(0, ItemStack.f_41583_);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.m_41619_()) {
                    ItemStack extra = carried.m_41620_(1);
                    if (!extra.m_41619_()) {
                        extra = interfaceSlot.addItems(extra);
                    }
                    if (extra.m_41619_()) break;
                    carried.m_41769_(extra.m_41613_());
                    break;
                }
                if (is.m_41619_()) break;
                this.m_142503_(interfaceSlot.extractItem(0, (is.m_41613_() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                ItemStack stack = interfaceSlot.getStackInSlot(0).m_41777_();
                if (!player.m_150109_().m_36054_(stack)) {
                    interfaceSlot.setItemDirect(0, stack);
                    break;
                }
                interfaceSlot.setItemDirect(0, ItemStack.f_41583_);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    ItemStack stack = inv.server.getStackInSlot(x);
                    if (!player.m_150109_().m_36054_(stack)) {
                        interfaceSlot.setItemDirect(0, stack);
                        continue;
                    }
                    interfaceSlot.setItemDirect(0, ItemStack.f_41583_);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.m_150110_().f_35937_ || !carried.m_41619_()) break;
                this.m_142503_(is.m_41619_() ? ItemStack.f_41583_ : is.m_41777_());
            }
        }
    }

    private void sendFullUpdate(@Nullable IGrid grid) {
        PatternProviderLogic dual;
        this.byId.clear();
        this.diList.clear();
        this.sendPacketToClient(InterfaceTerminalPacket.clearExistingData());
        if (grid == null) {
            return;
        }
        for (PatternProviderBlockEntity patternProviderBlockEntity : grid.getActiveMachines(PatternProviderBlockEntity.class)) {
            dual = patternProviderBlockEntity.getLogic();
            if (dual.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL) != YesNo.YES) continue;
            this.diList.put(patternProviderBlockEntity, new InvTracker(dual, dual.getPatternInv(), dual.getTermName()));
        }
        for (PatternProviderPart patternProviderPart : grid.getActiveMachines(PatternProviderPart.class)) {
            dual = patternProviderPart.getLogic();
            if (dual.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL) != YesNo.YES) continue;
            this.diList.put(patternProviderPart, new InvTracker(dual, dual.getPatternInv(), dual.getTermName()));
        }
        for (InvTracker invTracker : this.diList.values()) {
            this.byId.put(invTracker.serverId, (Object)invTracker);
            CompoundTag data = new CompoundTag();
            this.addItems(data, invTracker, 0, invTracker.server.size());
            this.sendPacketToClient(InterfaceTerminalPacket.inventory(invTracker.serverId, data));
        }
    }

    private void sendIncrementalUpdate() {
        for (InvTracker inv : this.diList.values()) {
            CompoundTag data = null;
            for (int x = 0; x < inv.server.size(); ++x) {
                if (!this.isDifferent(inv.server.getStackInSlot(x), inv.client.getStackInSlot(x))) continue;
                if (data == null) {
                    data = new CompoundTag();
                }
                this.addItems(data, inv, x, 1);
            }
            if (data == null) continue;
            this.sendPacketToClient(InterfaceTerminalPacket.inventory(inv.serverId, data));
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a.m_41619_() && b.m_41619_()) {
            return false;
        }
        if (a.m_41619_() || b.m_41619_()) {
            return true;
        }
        return !ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
    }

    private void addItems(CompoundTag tag, InvTracker inv, int offset, int length) {
        if (tag.m_128456_()) {
            tag.m_128356_("sortBy", inv.sortBy);
            tag.m_128359_("un", Component.Serializer.m_130703_((Component)inv.name));
        }
        for (int x = 0; x < length; ++x) {
            CompoundTag itemNBT = new CompoundTag();
            ItemStack is = inv.server.getStackInSlot(x + offset);
            inv.client.setItemDirect(x + offset, is.m_41619_() ? ItemStack.f_41583_ : is.m_41777_());
            if (!is.m_41619_()) {
                is.m_41739_(itemNBT);
            }
            tag.m_128365_(Integer.toString(x + offset), (Tag)itemNBT);
        }
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long serverId = inventorySerial++;
        private final Component name;
        private final InternalInventory client;
        private final InternalInventory server;

        public InvTracker(PatternProviderLogic dual, InternalInventory patterns, Component name) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(this.server.size());
            this.name = name;
            this.sortBy = dual.getSortValue();
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && stack.m_41720_() instanceof EncodedPatternItem;
        }
    }
}

