/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IMonitorPart;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.parts.AEBasePart;
import appeng.parts.reporting.ReportingModelData;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;

public abstract class AbstractReportingPart
extends AEBasePart
implements IMonitorPart,
IPowerChannelState {
    protected static final int POWERED_FLAG = 4;
    protected static final int CHANNEL_FLAG = 16;
    private static final int BOOTING_FLAG = 8;
    private byte spin = 0;
    private int clientFlags = 0;
    private int opacity = -1;

    protected AbstractReportingPart(IPartItem<?> partItem, boolean requireChannel) {
        super(partItem);
        if (requireChannel) {
            this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL);
            this.getMainNode().setIdlePowerUsage(0.5);
        } else {
            this.getMainNode().setIdlePowerUsage(0.0625);
        }
    }

    @Override
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT || !this.isLightSource()) {
            this.getHost().markForUpdate();
        }
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (pos.m_142300_(this.getSide()).equals((Object)neighbor)) {
            this.opacity = -1;
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.spin = data.m_128445_("spin");
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128344_("spin", this.getSpin());
    }

    @Override
    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.clientFlags = this.getSpin() & 3;
        IGridNode node = this.getMainNode().getNode();
        if (node != null) {
            if (node.isPowered()) {
                this.clientFlags = this.getClientFlags() | 4;
            }
            if (!node.hasGridBooted()) {
                this.clientFlags = this.getClientFlags() | 8;
            }
            if (node.meetsChannelRequirements()) {
                this.clientFlags = this.getClientFlags() | 0x10;
            }
        }
        data.writeByte((int)((byte)this.getClientFlags()));
        data.writeInt(this.opacity);
    }

    @Override
    public boolean readFromStream(FriendlyByteBuf data) {
        super.readFromStream(data);
        int oldFlags = this.getClientFlags();
        int oldOpacity = this.opacity;
        this.clientFlags = data.readByte();
        this.opacity = data.readInt();
        this.spin = (byte)(this.getClientFlags() & 3);
        return this.getClientFlags() != oldFlags || this.opacity != oldOpacity;
    }

    @Override
    public final int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    @Override
    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (InteractionUtil.canWrenchRotate(player.m_150109_().m_36056_())) {
            if (!this.isClientSide()) {
                this.spin = (byte)((this.spin + 1) % 4);
                this.getHost().markForUpdate();
                this.getHost().markForSave();
            }
            return true;
        }
        return super.onPartActivate(player, hand, pos);
    }

    @Override
    public final void onPlacement(Player player) {
        super.onPlacement(player);
        byte rotation = (byte)(Mth.m_14107_((double)((double)(player.m_146908_() * 4.0f / 360.0f) + 2.5)) & 3);
        if (this.getSide() == Direction.UP || this.getSide() == Direction.DOWN) {
            this.spin = rotation;
        }
    }

    private int blockLight(int emit) {
        if (this.opacity < 0) {
            BlockEntity te = this.getHost().getBlockEntity();
            Level level = te.m_58904_();
            BlockPos pos = te.m_58899_().m_142300_(this.getSide());
            this.opacity = 255 - level.m_8055_(pos).m_60739_((BlockGetter)level, pos);
        }
        return (int)((float)emit * ((float)this.opacity / 255.0f));
    }

    @Override
    public final boolean isPowered() {
        if (!this.isClientSide()) {
            IGridNode node = this.getMainNode().getNode();
            return node != null && node.isPowered();
        }
        return (this.getClientFlags() & 4) == 4;
    }

    @Override
    public final boolean isActive() {
        if (!this.isLightSource()) {
            return (this.getClientFlags() & 0x14) == 20;
        }
        return this.isPowered();
    }

    protected IPartModel selectModel(IPartModel offModels, IPartModel onModels, IPartModel hasChannelModels) {
        if (this.isActive()) {
            return hasChannelModels;
        }
        if (this.isPowered()) {
            return onModels;
        }
        return offModels;
    }

    @Override
    public IModelData getModelData() {
        return new ReportingModelData(this.getSpin());
    }

    public final int getClientFlags() {
        return this.clientFlags;
    }

    public final byte getSpin() {
        return this.spin;
    }

    public abstract boolean isLightSource();
}

