/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.server.ISubCommand;
import appeng.server.testworld.TestPlots;
import appeng.server.testworld.TestWorldGenerator;
import com.google.common.base.Stopwatch;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;

public class SetupTestWorldCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        for (ResourceLocation plotId : TestPlots.getPlotIds()) {
            builder.then(Commands.m_82127_((String)plotId.toString()).executes(ctx -> {
                this.setupTestWorld(((CommandSourceStack)ctx.getSource()).m_81377_(), (CommandSourceStack)ctx.getSource(), plotId);
                return 1;
            }));
        }
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSourceStack> ctx, CommandSourceStack sender) {
        this.setupTestWorld(srv, sender, null);
    }

    private void setupTestWorld(MinecraftServer srv, CommandSourceStack sender, @Nullable ResourceLocation plotId) {
        Stopwatch sw = Stopwatch.createStarted();
        try {
            ServerPlayer player = sender.m_81375_();
            if (!player.m_7500_()) {
                sender.m_81352_((Component)new TextComponent("Command can only be used in creative mode."));
                return;
            }
            ServerLevel level = srv.m_129783_();
            if (!SetupTestWorldCommand.isVoidWorld(level)) {
                sender.m_81352_((Component)new TextComponent("A test world can only be set up in a Superflat world with the Void preset!"));
                return;
            }
            SetupTestWorldCommand.changeGameRules(srv);
            BlockPos origin = new BlockPos(0, 60, 0);
            TestWorldGenerator generator = new TestWorldGenerator(level, player, origin, plotId);
            generator.generate();
            player.m_150110_().f_35935_ = true;
            player.m_6885_();
            this.kitOutPlayer(player);
            if (!generator.isWithinBounds(player.m_142538_())) {
                BlockPos goodStartPos = generator.getSuitableStartPos();
                player.m_8999_(level, (double)goodStartPos.m_123341_(), (double)goodStartPos.m_123342_(), (double)goodStartPos.m_123343_(), 0.0f, 0.0f);
            }
            sender.m_81354_((Component)new TextComponent("Test world setup completed in " + sw), true);
        }
        catch (CommandSyntaxException | RuntimeException e) {
            AELog.error(e);
            sender.m_81352_((Component)new TextComponent("Setting up the test world failed: " + (Exception)e));
        }
    }

    private void kitOutPlayer(ServerPlayer player) {
        Inventory playerInv = player.m_150109_();
        ItemStack fullApplicator = ColorApplicatorItem.createFullColorApplicator();
        if (!playerInv.m_18949_(Collections.singleton(AEItems.COLOR_APPLICATOR.m_5456_()))) {
            playerInv.m_150079_(fullApplicator);
        }
    }

    private static void changeGameRules(MinecraftServer srv) {
        SetupTestWorldCommand.makeAlwaysDaytime(srv);
        SetupTestWorldCommand.disableWeather(srv);
    }

    private static void makeAlwaysDaytime(MinecraftServer srv) {
        ((GameRules.BooleanValue)srv.m_129900_().m_46170_(GameRules.f_46140_)).m_46246_(false, srv);
        srv.m_129783_().m_8615_(1000L);
    }

    private static void disableWeather(MinecraftServer srv) {
        ((GameRules.BooleanValue)srv.m_129900_().m_46170_(GameRules.f_46150_)).m_46246_(false, srv);
        srv.m_129783_().m_8606_(9999, 0, false, false);
    }

    private static boolean isVoidWorld(ServerLevel level) {
        ChunkGenerator generator = level.m_7726_().m_8481_();
        if (!(generator instanceof FlatLevelSource)) {
            return false;
        }
        FlatLevelSource flatLevelSource = (FlatLevelSource)generator;
        return flatLevelSource.m_64191_().m_161917_().stream().allMatch(Objects::isNull);
    }
}

