/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.pathing.ChannelMode;
import appeng.api.parts.PartHelper;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AEColor;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.blockentity.misc.InterfaceBlockEntity;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.blockentity.storage.SkyStoneTankBlockEntity;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.storage.CreativeCellItem;
import appeng.items.tools.powered.MatterCannonItem;
import appeng.me.cells.BasicCellInventory;
import appeng.me.helpers.BaseActionSource;
import appeng.me.service.PathingService;
import appeng.menu.NullMenu;
import appeng.parts.automation.ImportBusPart;
import appeng.parts.crafting.PatternProviderPart;
import appeng.server.testworld.AutoCraftingTestPlot;
import appeng.server.testworld.DriveBuilder;
import appeng.server.testworld.P2PTestPlots;
import appeng.server.testworld.Plot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.TestCraftingJob;
import appeng.util.ConfigInventory;
import appeng.util.CraftingRecipeUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public final class TestPlots {
    public static final Map<ResourceLocation, Consumer<PlotBuilder>> PLOT_FACTORIES = ImmutableMap.builder().put((Object)AppEng.makeId("all_terminals"), TestPlots::allTerminals).put((Object)AppEng.makeId("item_chest"), TestPlots::itemChest).put((Object)AppEng.makeId("fluid_chest"), TestPlots::fluidChest).put((Object)AppEng.makeId("skycompass_rendering"), TestPlots::skyCompassRendering).put((Object)AppEng.makeId("crystal_growth_autocrafting"), TestPlots::crystalGrowthAutoCrafting).put((Object)AppEng.makeId("import_exportbus"), TestPlots::importExportBus).put((Object)AppEng.makeId("inscriber"), TestPlots::inscriber).put((Object)AppEng.makeId("autocrafting_testplot"), AutoCraftingTestPlot::create).put((Object)AppEng.makeId("import_and_export_in_one_tick"), TestPlots::importAndExportInOneTick).put((Object)AppEng.makeId("export_from_storagebus"), TestPlots::exportFromStorageBus).put((Object)AppEng.makeId("import_into_storagebus"), TestPlots::importIntoStorageBus).put((Object)AppEng.makeId("import_on_pulse"), TestPlots::importOnPulse).put((Object)AppEng.makeId("import_on_pulse_transactioncrash"), TestPlots::importOnPulseTransactionCrash).put((Object)AppEng.makeId("mattercannon_range"), TestPlots::matterCannonRange).put((Object)AppEng.makeId("insert_fluid_into_mechest"), TestPlots::testInsertFluidIntoMEChest).put((Object)AppEng.makeId("maxchannels_adhoctest"), TestPlots::maxChannelsAdHocTest).put((Object)AppEng.makeId("blockingmode_subnetwork_chesttest"), TestPlots::blockingModeSubnetworkChestTest).put((Object)AppEng.makeId("canceling_jobs_from_interfacecrash"), TestPlots::cancelingJobsFromInterfaceCrash).put((Object)AppEng.makeId("terminal_fullof_enchanteditems"), TestPlots::terminalFullOfEnchantedItems).put((Object)AppEng.makeId("p2p_me"), P2PTestPlots::me).put((Object)AppEng.makeId("p2p_items"), P2PTestPlots::item).put((Object)AppEng.makeId("p2p_fluids"), P2PTestPlots::fluid).put((Object)AppEng.makeId("p2p_energy"), P2PTestPlots::energy).put((Object)AppEng.makeId("p2p_light"), P2PTestPlots::light).put((Object)AppEng.makeId("import_from_cauldron"), TestPlots::importLavaFromCauldron).put((Object)AppEng.makeId("tool_repair_recipe"), TestPlots::toolRepairRecipe).build();

    private TestPlots() {
    }

    public static List<ResourceLocation> getPlotIds() {
        return new ArrayList<ResourceLocation>(PLOT_FACTORIES.keySet());
    }

    public static List<Plot> createPlots() {
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (Map.Entry<ResourceLocation, Consumer<PlotBuilder>> entry : PLOT_FACTORIES.entrySet()) {
            Plot plot = new Plot(entry.getKey());
            entry.getValue().accept(plot);
            plots.add(plot);
        }
        return plots;
    }

    @Nullable
    public static Plot getById(ResourceLocation name) {
        Consumer<PlotBuilder> factory = PLOT_FACTORIES.get(name);
        if (factory == null) {
            return null;
        }
        Plot plot = new Plot(name);
        factory.accept(plot);
        return plot;
    }

    public static void allTerminals(PlotBuilder plot) {
        ItemStack enchantedPickaxe = new ItemStack((ItemLike)Items.f_42390_);
        enchantedPickaxe.m_41663_(Enchantments.f_44987_, 3);
        AEItemKey enchantedPickaxeKey = AEItemKey.of(enchantedPickaxe);
        plot.creativeEnergyCell("0 -1 0");
        plot.cable("[-1,0] [0,8] 0", AEParts.COVERED_DENSE_CABLE);
        plot.part("0 [0,8] 0", Direction.WEST, AEParts.CABLE_ANCHOR);
        plot.block("[-1,0] 5 0", AEBlocks.CONTROLLER);
        plot.storageDrive(new BlockPos(0, 5, 1));
        plot.afterGridInitAt("0 5 1", (grid, gridNode) -> {
            MEStorage storage = grid.getStorageService().getInventory();
            BaseActionSource src = new BaseActionSource();
            storage.insert(AEItemKey.of((ItemLike)Items.f_42390_), 10L, Actionable.MODULATE, src);
            storage.insert(enchantedPickaxeKey, 1234L, Actionable.MODULATE, src);
            storage.insert(AEItemKey.of((ItemLike)Items.f_41841_), Integer.MAX_VALUE, Actionable.MODULATE, src);
        });
        int y = 0;
        for (AEColor color : TestPlots.getColorsTransparentFirst()) {
            PlotBuilder line = y >= 9 ? plot.transform(bb -> new BoundingBox(-1 - bb.m_162399_(), bb.m_162396_(), bb.m_162398_(), -1 - bb.m_162395_(), bb.m_162400_(), bb.m_162401_())).offset(0, y - 9, 0) : plot.offset(0, y, 0);
            ++y;
            line.cable("[1,9] 0 0", AEParts.GLASS_CABLE, color);
            if (color == AEColor.TRANSPARENT) {
                line.part("[1,9] 0 0", Direction.UP, AEParts.CABLE_ANCHOR);
            }
            line.part("1 0 0", Direction.NORTH, AEParts.TERMINAL);
            line.part("2 0 0", Direction.NORTH, AEParts.CRAFTING_TERMINAL);
            line.part("3 0 0", Direction.NORTH, AEParts.PATTERN_ENCODING_TERMINAL);
            line.part("4 0 0", Direction.NORTH, AEParts.PATTERN_ACCESS_TERMINAL);
            line.part("5 0 0", Direction.NORTH, AEParts.STORAGE_MONITOR, monitor -> {
                monitor.setConfiguredItem(enchantedPickaxeKey);
                monitor.setLocked(true);
            });
            line.part("6 0 0", Direction.NORTH, AEParts.CONVERSION_MONITOR, monitor -> {
                monitor.setConfiguredItem(AEItemKey.of((ItemLike)Items.f_41841_));
                monitor.setLocked(true);
            });
            line.part("7 0 0", Direction.NORTH, AEParts.MONITOR);
            line.part("8 0 0", Direction.NORTH, AEParts.SEMI_DARK_MONITOR);
            line.part("9 0 0", Direction.NORTH, AEParts.DARK_MONITOR);
        }
    }

    public static ArrayList<AEColor> getColorsTransparentFirst() {
        ArrayList<AEColor> colors = new ArrayList<AEColor>();
        Collections.addAll(colors, AEColor.values());
        colors.remove((Object)AEColor.TRANSPARENT);
        colors.add(0, AEColor.TRANSPARENT);
        return colors;
    }

    public static void itemChest(PlotBuilder plot) {
        plot.blockEntity("0 0 0", AEBlocks.CHEST, chest -> {
            Item item;
            ItemStack cellItem = AEItems.ITEM_CELL_1K.stack();
            StorageCell cellInv = StorageCells.getCellInventory(cellItem, null);
            Random r = new Random();
            for (int i = 0; i < 100 && cellInv.insert(AEItemKey.of((ItemLike)(item = Registry.f_122827_.m_203454_(r).map(Holder::m_203334_).get())), 64L, Actionable.MODULATE, new BaseActionSource()) != 0L; ++i) {
            }
            chest.setCell(cellItem);
        });
        plot.creativeEnergyCell("0 -1 0");
    }

    public static void fluidChest(PlotBuilder plot) {
        plot.blockEntity("0 0 0", AEBlocks.CHEST, chest -> {
            Fluid fluid;
            ItemStack cellItem = AEItems.FLUID_CELL_1K.stack();
            StorageCell cellInv = StorageCells.getCellInventory(cellItem, null);
            Random r = new Random();
            for (int i = 0; i < 100 && ((fluid = Registry.f_122822_.m_203454_(r).map(Holder::m_203334_).get()).m_6212_(Fluids.f_76191_) || !fluid.m_7444_(fluid.m_76145_()) || cellInv.insert(AEFluidKey.of(fluid), 64000L, Actionable.MODULATE, new BaseActionSource()) != 0L); ++i) {
            }
            chest.setCell(cellItem);
        });
        plot.creativeEnergyCell("0 -1 0");
    }

    public static void skyCompassRendering(PlotBuilder plot) {
        plot.block("1 0 1", Blocks.f_50069_);
        plot.blockEntity("0 0 1", AEBlocks.SKY_COMPASS, skyCompass -> skyCompass.setOrientation(Direction.WEST, Direction.UP));
        plot.blockEntity("1 0 0", AEBlocks.SKY_COMPASS, skyCompass -> skyCompass.setOrientation(Direction.NORTH, Direction.UP));
        plot.blockEntity("2 0 1", AEBlocks.SKY_COMPASS, skyCompass -> skyCompass.setOrientation(Direction.EAST, Direction.UP));
        plot.blockEntity("1 0 2", AEBlocks.SKY_COMPASS, skyCompass -> skyCompass.setOrientation(Direction.SOUTH, Direction.UP));
        plot.blockEntity("1 1 1", AEBlocks.SKY_COMPASS, skyCompass -> skyCompass.setOrientation(Direction.UP, Direction.EAST));
        plot.block("1 3 1", Blocks.f_50069_);
        plot.blockEntity("1 2 1", AEBlocks.SKY_COMPASS, skyCompass -> skyCompass.setOrientation(Direction.DOWN, Direction.EAST));
    }

    public static void crystalGrowthAutoCrafting(PlotBuilder plot) {
        plot.cable("[4,6] 1 6", AEParts.GLASS_CABLE);
        plot.part("6 1 6", Direction.UP, AEParts.FORMATION_PLANE);
        plot.part("5 1 6", Direction.UP, AEParts.QUARTZ_FIBER);
        plot.cable("7 1 6", AEParts.GLASS_CABLE);
        plot.part("7 1 6", Direction.UP, AEParts.QUARTZ_FIBER);
        plot.cable("6 1 7", AEParts.GLASS_CABLE);
        plot.part("6 1 7", Direction.UP, AEParts.QUARTZ_FIBER);
        plot.part("4 1 6", Direction.WEST, AEParts.QUARTZ_FIBER);
        plot.block("5 2 6", AEBlocks.QUARTZ_GROWTH_ACCELERATOR);
        plot.block("7 2 6", AEBlocks.QUARTZ_GROWTH_ACCELERATOR);
        plot.block("6 2 5", Blocks.f_50058_);
        plot.block("6 2 7", AEBlocks.QUARTZ_GROWTH_ACCELERATOR);
        plot.fluid("6 2 6", (Fluid)Fluids.f_76193_);
        plot.part("4 1 6", Direction.UP, AEParts.INTERFACE);
        plot.blockEntity("4 2 6", AEBlocks.PATTERN_PROVIDER, provider -> {
            provider.setPushDirection(Direction.DOWN);
            ItemStack encodedPattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{AEItems.CERTUS_CRYSTAL_SEED.genericStack(1L)}, new GenericStack[]{AEItems.CERTUS_QUARTZ_CRYSTAL.genericStack(1L)});
            provider.getLogic().getPatternInv().addItems(encodedPattern);
            encodedPattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{AEItems.FLUIX_CRYSTAL_SEED.genericStack(1L)}, new GenericStack[]{AEItems.FLUIX_CRYSTAL.genericStack(1L)});
            provider.getLogic().getPatternInv().addItems(encodedPattern);
            encodedPattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.genericStack(1L), GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42692_)), GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42451_))}, new GenericStack[]{AEItems.FLUIX_DUST.genericStack(2L)});
            provider.getLogic().getPatternInv().addItems(encodedPattern);
        });
        plot.cable("3 2 6", AEParts.GLASS_CABLE);
        plot.part("3 2 6", Direction.NORTH, AEParts.TERMINAL);
        plot.blockEntity("3 3 6", AEBlocks.DRIVE, drive -> {
            drive.getInternalInventory().addItems(CreativeCellItem.ofItems(new ItemLike[]{AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, Items.f_42692_, Items.f_42451_, AEItems.CERTUS_CRYSTAL_SEED, AEItems.FLUIX_CRYSTAL_SEED}));
            drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack());
        });
        plot.block("3 1 6", AEBlocks.CREATIVE_ENERGY_CELL);
        plot.block("3 0 6", AEBlocks.CRAFTING_STORAGE_64K);
        plot.cable("[4,6] 3 6", AEParts.GLASS_CABLE);
        plot.part("4 3 6", Direction.WEST, AEParts.QUARTZ_FIBER);
        plot.part("4 3 6", Direction.DOWN, AEParts.STORAGE_BUS, storageBus -> {
            ConfigInventory config = storageBus.getConfig();
            config.setStack(0, AEItems.CERTUS_QUARTZ_CRYSTAL.genericStack(1L));
            config.setStack(1, AEItems.FLUIX_CRYSTAL.genericStack(1L));
            config.setStack(2, AEItems.FLUIX_DUST.genericStack(1L));
        });
        plot.part("5 3 6", Direction.DOWN, AEParts.QUARTZ_FIBER);
        plot.part("6 3 6", Direction.DOWN, AEParts.ANNIHILATION_PLANE);
    }

    public static void importExportBus(PlotBuilder plot) {
        plot.chest("1 0 1", new ItemStack((ItemLike)Items.f_41841_, 16), new ItemStack((ItemLike)Items.f_42584_, 6));
        plot.block("1 1 1", Blocks.f_50332_);
        plot.creativeEnergyCell("3 -1 1");
        plot.cable("3 0 1").part(Direction.NORTH, AEParts.TERMINAL);
        plot.cable("2 0 1").part(Direction.WEST, AEParts.IMPORT_BUS);
        plot.cable("2 1 1").part(Direction.WEST, AEParts.EXPORT_BUS, bus -> bus.getConfig().setStack(0, new GenericStack(AEItemKey.of((ItemLike)Items.f_42584_), 1L)));
        plot.blockEntity("3 -1 0", AEBlocks.DRIVE, drive -> drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack()));
    }

    public static void inscriber(PlotBuilder plot) {
        TestPlots.processorInscriber(plot.offset(0, 1, 2), AEItems.LOGIC_PROCESSOR_PRESS, (ItemLike)Items.f_42417_);
        TestPlots.processorInscriber(plot.offset(5, 1, 2), AEItems.ENGINEERING_PROCESSOR_PRESS, (ItemLike)Items.f_42415_);
        TestPlots.processorInscriber(plot.offset(10, 1, 2), AEItems.CALCULATION_PROCESSOR_PRESS, AEItems.CERTUS_QUARTZ_CRYSTAL);
    }

    public static void processorInscriber(PlotBuilder plot, ItemLike processorPress, ItemLike processorMaterial) {
        plot.filledHopper("-1 3 0", Direction.DOWN, processorMaterial);
        plot.creativeEnergyCell("-1 2 1");
        plot.blockEntity("-1 2 0", AEBlocks.INSCRIBER, inscriber -> {
            inscriber.getInternalInventory().setItemDirect(0, new ItemStack(processorPress));
            inscriber.setOrientation(Direction.NORTH, Direction.WEST);
        });
        plot.filledHopper("1 3 0", Direction.DOWN, AEItems.SILICON);
        plot.creativeEnergyCell("1 2 1");
        plot.blockEntity("1 2 0", AEBlocks.INSCRIBER, inscriber -> {
            inscriber.getInternalInventory().setItemDirect(0, AEItems.SILICON_PRESS.stack());
            inscriber.setOrientation(Direction.NORTH, Direction.WEST);
        });
        plot.hopper("1 1 0", Direction.WEST, new ItemStack[0]);
        plot.hopper("-1 1 0", Direction.EAST, new ItemStack[0]);
        plot.filledHopper("0 2 0", Direction.DOWN, (ItemLike)Items.f_42451_);
        plot.creativeEnergyCell("0 1 1");
        plot.blockEntity("0 1 0", AEBlocks.INSCRIBER, inscriber -> inscriber.setOrientation(Direction.NORTH, Direction.WEST));
        plot.hopper("0 0 0", Direction.DOWN, new ItemStack[0]);
    }

    public static void importAndExportInOneTick(PlotBuilder plot) {
        plot.creativeEnergyCell("-1 0 0");
        plot.chest("0 0 1", new ItemStack[0]);
        plot.cable("0 0 0").part(Direction.SOUTH, AEParts.EXPORT_BUS, exportBus -> {
            exportBus.getUpgrades().addItems(AEItems.CRAFTING_CARD.stack());
            exportBus.getConfig().addFilter((ItemLike)Items.f_42647_);
        });
        plot.cable("0 1 0");
        plot.cable("0 1 -1").craftingEmitter(Direction.DOWN, (ItemLike)Items.f_42647_);
        plot.cable("0 0 -1").part(Direction.NORTH, AEParts.IMPORT_BUS, part -> {
            part.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            part.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.HIGH_SIGNAL);
        });
        plot.block("1 0 0", AEBlocks.CRAFTING_STORAGE_1K);
        plot.chest("0 0 -2", new ItemStack((ItemLike)Items.f_42647_, 1));
        plot.test(helper -> helper.m_177361_(() -> {
            helper.m_177242_(new BlockPos(0, 0, 1), Items.f_42647_);
            helper.m_177440_(new BlockPos(0, 0, -2));
        }));
    }

    public static void exportFromStorageBus(PlotBuilder plot) {
        plot.creativeEnergyCell("1 0 0");
        plot.cable("0 0 0").part(Direction.SOUTH, AEParts.EXPORT_BUS, part -> part.getConfig().addFilter((ItemLike)Items.f_42647_)).part(Direction.NORTH, AEParts.STORAGE_BUS);
        plot.chest("0 0 1", new ItemStack[0]);
        plot.chest("0 0 -1", new ItemStack((ItemLike)Items.f_42647_));
        plot.test(helper -> helper.m_177361_(() -> {
            helper.m_177242_(new BlockPos(0, 0, 1), Items.f_42647_);
            helper.m_177440_(new BlockPos(0, 0, -1));
        }));
    }

    public static void importIntoStorageBus(PlotBuilder plot) {
        plot.creativeEnergyCell("1 0 0");
        plot.cable("0 0 0").part(Direction.NORTH, AEParts.IMPORT_BUS).part(Direction.SOUTH, AEParts.STORAGE_BUS);
        plot.chest("0 0 1", new ItemStack[0]);
        plot.chest("0 0 -1", new ItemStack((ItemLike)Items.f_42647_));
        plot.test(helper -> {
            helper.m_177361_(() -> {
                helper.m_177242_(new BlockPos(0, 0, 1), Items.f_42647_);
                helper.m_177440_(new BlockPos(0, 0, -1));
            });
            helper.m_177425_().m_177544_(10).m_177543_();
        });
    }

    public static void importOnPulse(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        BlockPos inputPos = origin.m_142128_();
        plot.creativeEnergyCell(origin.m_142125_().m_142125_());
        plot.storageDrive(origin.m_142125_());
        plot.cable(origin).part(Direction.SOUTH, AEParts.IMPORT_BUS, bus -> {
            bus.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            bus.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.SIGNAL_PULSE);
        }).part(Direction.NORTH, AEParts.TERMINAL);
        plot.chest(inputPos, new ItemStack((ItemLike)Items.f_42647_));
        plot.block(origin.m_142126_(), Blocks.f_50069_);
        BlockPos leverPos = plot.leverOn(origin.m_142126_(), Direction.NORTH);
        plot.test(helper -> {
            net.minecraft.world.level.block.entity.ChestBlockEntity inputChest = (net.minecraft.world.level.block.entity.ChestBlockEntity)helper.m_177347_(inputPos);
            IGrid grid = helper.getGrid(origin);
            Runnable assertNothingMoved = () -> helper.m_177242_(inputPos, Items.f_42647_);
            Runnable assertMoved = () -> {
                helper.m_177440_(inputPos);
                helper.assertContains(grid, Items.f_42647_);
            };
            Runnable reset = () -> {
                inputChest.m_6211_();
                helper.clearStorage(grid);
                inputChest.m_6836_(0, new ItemStack((ItemLike)Items.f_42647_));
            };
            Runnable toggleSignal = () -> helper.m_177421_(leverPos);
            helper.m_177425_().m_177546_(1, assertNothingMoved).m_177562_(toggleSignal).m_177562_(assertNothingMoved).m_177546_(1, assertMoved).m_177562_(reset).m_177562_(toggleSignal).m_177559_(30, assertNothingMoved).m_177543_();
        });
    }

    public static void importOnPulseTransactionCrash(PlotBuilder plot) {
        plot.creativeEnergyCell("1 0 0");
        plot.chest("0 0 -1", new ItemStack((ItemLike)Items.f_42647_));
        plot.chest("0 0 1", new ItemStack[0]);
        plot.block("0 1 0", Blocks.f_50330_);
        plot.cable("-1 0 0");
        plot.cable("-1 0 -1").part(Direction.EAST, AEParts.STORAGE_BUS, storageBus -> storageBus.getConfigManager().putSetting(Settings.ACCESS, AccessRestriction.READ));
        plot.cable("0 0 0").part(Direction.SOUTH, AEParts.STORAGE_BUS);
        plot.test(helper -> helper.m_177425_().m_177546_(1, () -> {
            BlockPos pos = helper.m_177449_(BlockPos.f_121853_);
            ImportBusPart importBus = (ImportBusPart)PartHelper.setPart(helper.m_177100_(), pos, Direction.NORTH, null, AEParts.IMPORT_BUS.m_5456_());
            importBus.getUpgrades().addItems(AEItems.REDSTONE_CARD.stack());
            importBus.getConfigManager().putSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.SIGNAL_PULSE);
        }).m_177559_(100, () -> helper.m_177440_(new BlockPos(0, 0, 1))).m_177543_()).setupTicks(20).maxTicks(150);
    }

    public static void matterCannonRange(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.fencedEntity(origin.m_142082_(0, 0, 5), EntityType.f_20557_, entity -> entity.m_20225_(true));
        plot.creativeEnergyCell(origin.m_7495_());
        plot.blockEntity(origin, AEBlocks.CHEST, chest -> chest.setCell(TestPlots.createMatterCannon(Items.f_42749_)));
        plot.block("-2 [0,1] 5", Blocks.f_50069_);
        plot.block("2 [0,1] 5", Blocks.f_50069_);
        plot.creativeEnergyCell(origin.m_142125_().m_7495_());
        plot.block(origin.m_142125_(), AEBlocks.CHARGER);
        TestPlots.matterCannonDispenser(plot.offset(-2, 1, 1), AEItems.COLORED_LUMEN_PAINT_BALL.item(AEColor.PURPLE));
        TestPlots.matterCannonDispenser(plot.offset(0, 1, 1), Items.f_42749_);
        TestPlots.matterCannonDispenser(plot.offset(2, 1, 1), new Item[0]);
    }

    private static void matterCannonDispenser(PlotBuilder plot, Item ... ammos) {
        plot.blockState(BlockPos.f_121853_, (BlockState)Blocks.f_50061_.m_49966_().m_61124_((Property)DispenserBlock.f_52659_, (Comparable)Direction.SOUTH));
        plot.customizeBlockEntity(BlockPos.f_121853_, BlockEntityType.f_58922_, dispenser -> dispenser.m_59237_(TestPlots.createMatterCannon(ammos)));
        plot.buttonOn(BlockPos.f_121853_, Direction.NORTH);
    }

    private static ItemStack createMatterCannon(Item ... ammo) {
        ItemStack cannon = AEItems.MATTER_CANNON.stack();
        ((MatterCannonItem)cannon.m_41720_()).injectAEPower(cannon, Double.MAX_VALUE, Actionable.MODULATE);
        BasicCellInventory cannonInv = BasicCellInventory.createInventory(cannon, null);
        for (Item item : ammo) {
            cannonInv.insert(AEItemKey.of((ItemLike)item), item.m_41459_(), Actionable.MODULATE, new BaseActionSource());
        }
        return cannon;
    }

    public static void testInsertFluidIntoMEChest(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.blockEntity(origin, AEBlocks.CHEST, chest -> chest.setCell(AEItems.FLUID_CELL_4K.stack()));
        plot.cable(origin.m_142126_()).part(Direction.WEST, AEParts.EXPORT_BUS, bus -> bus.getConfig().addFilter((Fluid)Fluids.f_76193_));
        plot.blockEntity(origin.m_142126_().m_142127_(), AEBlocks.DRIVE, drive -> drive.getInternalInventory().addItems(CreativeCellItem.ofFluids(new Fluid[]{Fluids.f_76193_})));
        plot.creativeEnergyCell(origin.m_142126_().m_142127_().m_7495_());
        plot.test(helper -> helper.m_177361_(() -> {
            ChestBlockEntity meChest = (ChestBlockEntity)helper.m_177347_(origin);
            helper.assertContains(meChest.getInventory(), AEFluidKey.of((Fluid)Fluids.f_76193_));
        }));
    }

    public static void maxChannelsAdHocTest(PlotBuilder plot) {
        plot.creativeEnergyCell("0 -1 0");
        plot.block("[-3,3] -2 [-3,3]", AEBlocks.DRIVE);
        plot.cable("[-3,3] 0 [-3,3]", AEParts.SMART_DENSE_CABLE);
        plot.cable("[-3,3] [1,64] [-3,2]").part(Direction.EAST, AEParts.TERMINAL).part(Direction.NORTH, AEParts.TERMINAL).part(Direction.WEST, AEParts.TERMINAL).part(Direction.WEST, AEParts.TERMINAL);
        plot.cable("[-3,3] [1,64] 3").part(Direction.NORTH, AEParts.PATTERN_PROVIDER).part(Direction.SOUTH, AEParts.PATTERN_PROVIDER).part(Direction.EAST, AEParts.PATTERN_PROVIDER).part(Direction.WEST, AEParts.PATTERN_PROVIDER);
        plot.afterGridExistsAt("0 0 0", (grid, node) -> {
            ((PathingService)grid.getPathingService()).setForcedChannelMode(ChannelMode.INFINITE);
            Iterator<PatternProviderPart> patternProviders = grid.getMachines(PatternProviderPart.class).iterator();
            PatternProviderPart current = patternProviders.next();
            List craftingRecipes = node.getLevel().m_7465_().m_44013_(RecipeType.f_44107_);
            HashSet<AEItemKey> neededIngredients = new HashSet<AEItemKey>();
            HashSet<AEItemKey> providedResults = new HashSet<AEItemKey>();
            for (CraftingRecipe recipe : craftingRecipes) {
                ItemStack craftingPattern;
                block8: {
                    if (recipe.m_5598_()) continue;
                    try {
                        ItemStack[] ingredients = (ItemStack[])CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe).stream().map(i -> {
                            if (i.m_43947_()) {
                                return ItemStack.f_41583_;
                            }
                            return i.m_43908_()[0];
                        }).toArray(ItemStack[]::new);
                        craftingPattern = PatternDetailsHelper.encodeCraftingPattern(recipe, ingredients, recipe.m_8043_(), false, false);
                        for (ItemStack ingredient : ingredients) {
                            AEItemKey key = AEItemKey.of(ingredient);
                            if (key == null) continue;
                            neededIngredients.add(key);
                        }
                        if (recipe.m_8043_().m_41619_()) break block8;
                        providedResults.add(AEItemKey.of(recipe.m_8043_()));
                    }
                    catch (Exception e) {
                        AELog.warn(e);
                        continue;
                    }
                }
                if (current.getLogic().getPatternInv().addItems(craftingPattern).m_41619_()) continue;
                if (!patternProviders.hasNext()) break;
                current = patternProviders.next();
                current.getLogic().getPatternInv().addItems(craftingPattern);
            }
            UnmodifiableIterator keysToAdd = Sets.difference(neededIngredients, providedResults).iterator();
            block4: for (DriveBlockEntity drive : grid.getMachines(DriveBlockEntity.class)) {
                InternalInventory cellInv = drive.getInternalInventory();
                for (int i2 = 0; i2 < cellInv.size(); ++i2) {
                    ItemStack creativeCell = AEItems.ITEM_CELL_CREATIVE.stack();
                    ConfigInventory configInv = AEItems.ITEM_CELL_CREATIVE.m_5456_().getConfigInventory(creativeCell);
                    for (int j = 0; j < configInv.size(); ++j) {
                        if (!keysToAdd.hasNext()) {
                            cellInv.addItems(creativeCell);
                            break block4;
                        }
                        AEItemKey keyToAdd = (AEItemKey)keysToAdd.next();
                        configInv.setStack(j, new GenericStack(keyToAdd, 1L));
                    }
                    cellInv.addItems(creativeCell);
                }
            }
        });
    }

    public static void blockingModeSubnetworkChestTest(PlotBuilder plot) {
        plot.creativeEnergyCell("0 -1 0");
        plot.block("[0,1] [0,1] [0,1]", AEBlocks.CRAFTING_ACCELERATOR);
        plot.block("0 0 0", AEBlocks.CRAFTING_STORAGE_64K);
        GenericStack input = GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42417_));
        GenericStack output = GenericStack.fromItemStack(new ItemStack((ItemLike)Items.f_42415_));
        plot.cable("2 0 0").part(Direction.EAST, AEParts.PATTERN_PROVIDER, pp -> {
            pp.getLogic().getPatternInv().addItems(PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{input}, new GenericStack[]{output}));
            pp.getLogic().getConfigManager().putSetting(Settings.BLOCKING_MODE, YesNo.YES);
        });
        plot.drive(new BlockPos(2, 0, -1)).addCreativeCell().add(input);
        plot.creativeEnergyCell("3 -1 0");
        plot.cable("3 0 0").part(Direction.WEST, AEParts.INTERFACE).part(Direction.EAST, AEParts.STORAGE_BUS);
        plot.block("4 0 0", Blocks.f_50087_);
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), BlockPos.f_121853_, output.what(), 64L);
            helper.m_177425_().m_177552_(craftingJob::tickUntilStarted).m_177552_(() -> {
                IGrid grid = helper.getGrid(BlockPos.f_121853_);
                long requesting = grid.getCraftingService().getRequestedAmount(output.what());
                helper.check(requesting > 0L, "not yet requesting items");
                if (requesting != 1L) {
                    helper.m_177284_("blocking mode failed, requesting: " + requesting);
                }
            }).m_177543_();
        });
    }

    public static void cancelingJobsFromInterfaceCrash(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin);
        plot.blockEntity(origin.m_7494_(), AEBlocks.INTERFACE, iface -> {
            iface.getUpgrades().addItems(AEItems.CRAFTING_CARD.stack());
            iface.getConfig().setStack(0, new GenericStack(AEItemKey.of((ItemLike)Items.f_42647_), 1L));
        });
        plot.block(origin.m_142126_(), AEBlocks.CRAFTING_STORAGE_1K);
        plot.cable(origin.m_142125_()).craftingEmitter(Direction.WEST, (ItemLike)Items.f_42647_);
        plot.test(helper -> helper.m_177425_().m_177552_(() -> {
            IGrid grid = helper.getGrid(origin);
            helper.check(grid.getCraftingService().isRequesting(AEItemKey.of((ItemLike)Items.f_42647_)), "Interface is not crafting oak planks");
        }).m_177562_(() -> {
            InterfaceBlockEntity iface = (InterfaceBlockEntity)helper.m_177347_(origin.m_7494_());
            iface.getUpgrades().removeItems(1, ItemStack.f_41583_, null);
            IGrid grid = helper.getGrid(origin);
            long inserted = grid.getStorageService().getInventory().insert(AEItemKey.of((ItemLike)Items.f_42647_), 1L, Actionable.MODULATE, new BaseActionSource());
            helper.check(inserted == 0L, "Nothing should have been inserted into the network");
            helper.check(iface.getInterfaceLogic().getStorage().isEmpty(), "Nothing should have been inserted into the interface");
        }).m_177543_()).maxTicks(300);
    }

    public static void terminalFullOfEnchantedItems(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.cable(origin).part(Direction.NORTH, AEParts.TERMINAL);
        DriveBuilder drive = plot.drive(origin.m_142126_());
        ItemStack pickaxe = new ItemStack((ItemLike)Items.f_42390_);
        pickaxe.m_41663_(Enchantments.f_44987_, 1);
        for (int i = 0; i < 10; ++i) {
            DriveBuilder.ItemCellBuilder cell = drive.addItemCell64k();
            for (int j = 0; j < 63; ++j) {
                pickaxe.m_41721_(pickaxe.m_41773_() + 1);
                cell.add(AEItemKey.of(pickaxe), 2L);
            }
        }
    }

    public static void importLavaFromCauldron(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.creativeEnergyCell(origin.m_7495_());
        plot.cable(origin).part(Direction.EAST, AEParts.IMPORT_BUS, importBus -> importBus.getUpgrades().addItems(AEItems.SPEED_CARD.stack())).part(Direction.WEST, AEParts.STORAGE_BUS);
        plot.block(origin.m_142125_(), AEBlocks.SKY_STONE_TANK);
        plot.block(origin.m_142126_(), Blocks.f_152477_);
        plot.test(helper -> helper.m_177361_(() -> {
            helper.m_177208_(Blocks.f_50256_, origin.m_142126_());
            SkyStoneTankBlockEntity tank = (SkyStoneTankBlockEntity)helper.m_177347_(origin.m_142125_());
            helper.check(tank.getStorage().getFluidAmount() == 1000, "Less than a bucket stored");
            helper.check(tank.getStorage().getFluid().getFluid() == Fluids.f_76195_, "Something other than lava stored");
        }));
    }

    public static void toolRepairRecipe(PlotBuilder plot) {
        AEItemKey undamaged = AEItemKey.of((ItemLike)Items.f_42390_);
        int maxDamage = undamaged.getFuzzySearchMaxValue();
        AEItemKey damaged = (AEItemKey)Util.m_137537_(() -> {
            ItemStack is = undamaged.toStack();
            is.m_41721_(maxDamage - 1);
            return AEItemKey.of(is);
        });
        AEItemKey correctResult = (AEItemKey)Util.m_137537_(() -> {
            ItemStack is = undamaged.toStack();
            int usesLeft = 2 + maxDamage * 5 / 100;
            is.m_41721_(maxDamage - usesLeft);
            return AEItemKey.of(is);
        });
        plot.creativeEnergyCell("0 0 0");
        BlockPos molecularAssemblerPos = new BlockPos(0, 1, 0);
        plot.blockEntity(molecularAssemblerPos, AEBlocks.MOLECULAR_ASSEMBLER, molecularAssembler -> {
            CraftingContainer craftingContainer = new CraftingContainer((AbstractContainerMenu)new NullMenu(), 3, 3);
            craftingContainer.m_6836_(0, undamaged.toStack());
            craftingContainer.m_6836_(1, undamaged.toStack());
            Level level = molecularAssembler.m_58904_();
            CraftingRecipe recipe = (CraftingRecipe)level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingContainer, level).get();
            ItemStack[] sparseInputs = new ItemStack[9];
            sparseInputs[0] = undamaged.toStack();
            sparseInputs[1] = undamaged.toStack();
            for (int i = 2; i < 9; ++i) {
                sparseInputs[i] = ItemStack.f_41583_;
            }
            ItemStack encodedPattern = PatternDetailsHelper.encodeCraftingPattern(recipe, sparseInputs, undamaged.toStack(), true, false);
            IPatternDetails patternDetails = PatternDetailsHelper.decodePattern(encodedPattern, level);
            KeyCounter[] table = new KeyCounter[]{new KeyCounter()};
            table[0].add(damaged, 2L);
            molecularAssembler.pushPattern(patternDetails, table, Direction.UP);
        });
        plot.test(helper -> helper.m_177306_(40L, () -> {
            MolecularAssemblerBlockEntity molecularAssembler = (MolecularAssemblerBlockEntity)helper.m_177347_(molecularAssemblerPos);
            ItemStack outputItem = molecularAssembler.getInternalInventory().getStackInSlot(9);
            if (correctResult.matches(outputItem)) {
                helper.m_177412_();
            } else if (undamaged.matches(outputItem)) {
                helper.m_177284_("created undamaged item");
            }
        }));
    }
}

