/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.tool.slingshot;

import it.unimi.dsi.fastutil.objects.AbstractObject2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.Event;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.item.tool.slingshot.AbstractSlingshotAmmoBehavior;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGEnchantments;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class SlingshotItem
extends ProjectileWeaponItem {
    private static final Map<Item, AbstractSlingshotAmmoBehavior> AMMO_REGISTRY = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), AbstractObject2ObjectFunction::defaultReturnValue);

    public SlingshotItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(192).m_41497_(Rarity.UNCOMMON));
    }

    public int getMaxDamage(ItemStack stack) {
        int longevity = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)UGEnchantments.LONGEVITY.get()), (ItemStack)stack);
        int durability = super.getMaxDamage(stack);
        if (longevity > 0) {
            return durability * (longevity + 1);
        }
        return durability;
    }

    public static void registerAmmo(ItemLike item, AbstractSlingshotAmmoBehavior behavior) {
        AMMO_REGISTRY.put(item.m_5456_(), behavior);
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> AMMO_REGISTRY.containsKey(stack.m_41720_());
    }

    public int m_6615_() {
        return 10;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean isCreative = player.m_150110_().f_35937_;
            ItemStack projectileStack = player.m_6298_(stack);
            boolean selfSling = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)UGEnchantments.SELF_SLING.get()), (ItemStack)stack) > 0;
            int useTime = this.m_8105_(stack) - timeLeft;
            if ((useTime = SlingshotItem.onArrowLoose(stack, level, player, useTime, !projectileStack.m_41619_() || isCreative || selfSling)) < 0) {
                return;
            }
            float velocity = SlingshotItem.getProjectileVelocity(useTime);
            if (selfSling) {
                if (!player.m_20096_()) {
                    return;
                }
                Vec3 delta = player.m_20154_();
                player.m_5997_(delta.f_82479_ * (double)(velocity * 2.0f), delta.f_82480_ * (double)velocity + (double)(velocity / 2.0f), delta.f_82481_ * (double)(velocity * 2.0f));
                if (!level.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, player1 -> player.m_21190_(player.m_7655_()));
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)UGSoundEvents.SLINGSHOT_SHOOT.get(), SoundSource.PLAYERS, 0.5f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + velocity * 0.5f);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            if (!projectileStack.m_41619_() && !selfSling) {
                if (projectileStack.m_150930_(Items.f_42412_)) {
                    projectileStack = new ItemStack((ItemLike)UGItems.DEPTHROCK_PEBBLE.get());
                }
                if (!((double)velocity < 0.1)) {
                    if (!level.f_46443_) {
                        SlingshotProjectile slingshotProjectile = AMMO_REGISTRY.get(projectileStack.m_41720_()).getProjectile(level, entity.m_20183_(), player, projectileStack);
                        slingshotProjectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity * 2.0f, 1.0f);
                        stack.m_41622_(1, (LivingEntity)player, player1 -> player.m_21190_(player.m_7655_()));
                        int ricochet = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)UGEnchantments.RICOCHET.get()), (ItemStack)stack);
                        if (ricochet > 0) {
                            slingshotProjectile.setRicochetTimes(ricochet + 1);
                        }
                        level.m_7967_((Entity)slingshotProjectile);
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), AMMO_REGISTRY.get(projectileStack.m_41720_()).getFiringSound(), SoundSource.PLAYERS, 0.5f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + velocity * 0.5f);
                        UGCriteria.SLINGSHOT_FIRE.trigger((ServerPlayer)player, stack, projectileStack);
                    }
                    AMMO_REGISTRY.get(projectileStack.m_41720_()).addAdditionalFiringEffects(level, player);
                    if (!isCreative) {
                        projectileStack.m_41774_(1);
                        if (projectileStack.m_41619_()) {
                            player.m_150109_().m_36057_(projectileStack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean hasAmmo = !player.m_6298_(stack).m_41619_();
        boolean selfSling = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)UGEnchantments.SELF_SLING.get()), (ItemStack)stack) > 0;
        InteractionResultHolder<ItemStack> ret = SlingshotItem.onArrowNock(stack, level, player, hand, hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!(player.m_150110_().f_35937_ || hasAmmo || selfSling)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)UGSoundEvents.SLINGSHOT_DRAW.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public static InteractionResultHolder<ItemStack> onArrowNock(ItemStack stack, Level level, Player player, InteractionHand hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, stack, hand, level, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        return event.getAction();
    }

    public static int onArrowLoose(ItemStack stack, Level level, Player player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, level, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 5.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(ItemTags.f_13168_);
    }
}

