/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.preview.QuantifiedIngredient;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.config.DebugCfg;
import tictim.paraglider.config.FeatureCfg;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.forge.ParagliderUtilsImpl;
import tictim.paraglider.impl.movement.ClientPlayerMovement;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerStateConnectionMap;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.movement.RemotePlayerMovement;
import tictim.paraglider.impl.movement.ServerPlayerMovement;

public final class ParagliderUtils {
    public static final Random DIALOG_RNG = new Random();
    public static final Random PARTICLE_RNG = new Random();
    private static final UUID EXHAUSTION_ATTRIBUTE_UUID = UUID.fromString("65ed2ca4-ceb3-4521-8552-73006dcba58d");
    private static final double EXHAUSTION_AMOUNT = -0.3;
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("#.#%");

    private ParagliderUtils() {
    }

    public static void giveItem(@NotNull Player player, @NotNull ItemStack stack) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        while (!stack.m_41619_()) {
            int slot = player.m_150109_().m_36050_(stack);
            if (slot == -1) {
                slot = player.m_150109_().m_36062_();
            }
            if (slot == -1) {
                while (!stack.m_41619_()) {
                    ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), stack.m_41620_(stack.m_41741_()));
                    itemEntity.m_32010_(40);
                    itemEntity.m_20334_(0.0, 0.0, 0.0);
                    player.m_9236_().m_7967_((Entity)itemEntity);
                }
                break;
            }
            int count = stack.m_41741_() - player.m_150109_().m_8020_(slot).m_41613_();
            if (!player.m_150109_().m_36040_(slot, stack.m_41620_(count)) || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, slot, player.m_150109_().m_8020_(slot)));
        }
    }

    @Nullable
    public static Item getAppropriateVessel() {
        FeatureCfg cfg = FeatureCfg.get();
        return cfg.enableHeartContainers() ? Contents.get().heartContainer() : (cfg.enableStaminaVessels() ? Contents.get().staminaVessel() : null);
    }

    public static void addExhaustion(@NotNull LivingEntity entity) {
        AttributeInstance attr = entity.m_21051_(Attributes.f_22279_);
        if (attr == null || attr.m_22111_(EXHAUSTION_ATTRIBUTE_UUID) != null) {
            return;
        }
        attr.m_22118_(new AttributeModifier(EXHAUSTION_ATTRIBUTE_UUID, "Exhaustion", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public static void removeExhaustion(@NotNull LivingEntity entity) {
        AttributeInstance attr = entity.m_21051_(Attributes.f_22279_);
        if (attr == null) {
            return;
        }
        attr.m_22120_(EXHAUSTION_ATTRIBUTE_UUID);
    }

    public static boolean giveAdvancement(@NotNull ServerPlayer player, @NotNull ResourceLocation advancementName, @NotNull String criterion) {
        PlayerAdvancements advancements = player.m_8960_();
        ServerAdvancementManager advancementManager = player.f_8924_.m_129889_();
        Advancement advancement = advancementManager.m_136041_(advancementName);
        return advancement != null && advancements.m_135988_(advancement, criterion);
    }

    public static void damageItemWithoutBreaking(@NotNull Player player, @NotNull ItemStack stack) {
        int prevCount = stack.m_41613_();
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        if (stack.m_41613_() < prevCount) {
            stack.m_41764_(prevCount);
            stack.m_41721_(stack.m_41776_());
        }
    }

    public static void checkBargainRecipes(@NotNull MinecraftServer server) {
        List recipes = server.m_129894_().m_44013_(Contents.get().bargainRecipeType());
        BargainTypeRegistry typeRegistry = BargainTypeRegistry.get();
        Object2ObjectAVLTreeMap missingBargainTypes = new Object2ObjectAVLTreeMap();
        int count = 0;
        for (Bargain b : recipes) {
            ResourceLocation bargainType = b.getBargainType();
            if (typeRegistry.getFromID(server, Objects.requireNonNull(bargainType)) != null) continue;
            missingBargainTypes.computeIfAbsent(bargainType, s -> new ArrayList()).add(Objects.requireNonNull(b.m_6423_()));
            ++count;
        }
        if (count > 0) {
            ParagliderMod.LOGGER.error("Found {} issues in bargain recipes:\n  {}", (Object)count, (Object)missingBargainTypes.entrySet().stream().map(e -> "Cannot resolve bargain type " + e.getKey() + (((List)e.getValue()).size() == 1 ? " for bargain recipe " + ((List)e.getValue()).get(0) : " for bargain recipes " + ((List)e.getValue()).stream().map(Object::toString).collect(Collectors.joining(", ")))).collect(Collectors.joining("\n  ")));
        }
    }

    public static boolean calculateConsumption(@NotNull QuantifiedIngredient ingredient, @NotNull Container inventory, @NotNull Int2IntOpenHashMap consumptions) {
        int amountLeft = ingredient.quantity();
        for (int i = 0; amountLeft > 0 && i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            int consumption = consumptions.get(i);
            if (consumption >= stack.m_41613_() || !ingredient.test(stack)) continue;
            int amountToConsume = Math.min(amountLeft, stack.m_41613_() - consumption);
            amountLeft -= amountToConsume;
            consumptions.put(i, consumption + amountToConsume);
        }
        return amountLeft <= 0;
    }

    public static void addDebugText(@NotNull Player p, @NotNull List<String> list) {
        Movement movement = Movement.get(p);
        Stamina stamina = Stamina.get(p);
        VesselContainer vessels = VesselContainer.get(p);
        ParagliderClientSettings clientSettings = ParagliderClientSettings.get();
        if (!list.isEmpty()) {
            list.add("");
        }
        PlayerState state = movement.state();
        list.add("State: " + state.id() + " (staminaDelta=" + state.staminaDelta() + ", recoveryDelay=" + state.recoveryDelay() + (String)(state.flags().isEmpty() ? "" : ", flags=" + state.flags().stream().map(Object::toString).collect(Collectors.joining(" "))) + ")");
        list.add((Serializable)(stamina.isDepleted() ? ChatFormatting.RED : "") + "Stamina: " + stamina.stamina() + " / " + stamina.maxStamina());
        list.add(vessels.staminaVessel() + " Stamina Vessels, " + vessels.heartContainer() + " Heart Containers");
        list.add(movement.recoveryDelay() + " Recovery Delay");
        list.add("Stamina Wheel X: " + PERCENTAGE.format(clientSettings.staminaWheelX()) + ", Stamina Wheel Y: " + PERCENTAGE.format(clientSettings.staminaWheelY()));
    }

    public static long ms() {
        return System.nanoTime() / 1000000L;
    }

    @NotNull
    public static PlayerMovement createPlayerMovement(@NotNull Player player) {
        PlayerMovement playerMovement;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            playerMovement = new ServerPlayerMovement(serverPlayer);
        } else {
            playerMovement = ParagliderUtils.isClient() ? ClientImpl.createPlayerMovement(player) : new RemotePlayerMovement(player);
        }
        return playerMovement;
    }

    public static void printPlayerStates(@NotNull PlayerStateMap stateMap, @NotNull PlayerStateConnectionMap connectionMap) {
        if (!DebugCfg.get().debugPlayerMovement()) {
            return;
        }
        ParagliderMod.LOGGER.debug("All Player States: " + stateMap.states().size() + " entries" + stateMap.states().values().stream().map(s -> "\n  " + s.id() + " : staminaDelta=" + s.staminaDelta() + ", recoveryDelay=" + s.recoveryDelay() + (String)(s.flags().isEmpty() ? "" : ", flags=[" + s.flags().stream().map(f -> f.toString()).collect(Collectors.joining(", ")) + "]")).collect(Collectors.joining()));
        StringBuilder stb = new StringBuilder("All Player State Connections: ").append(connectionMap.connections().size()).append(" entries");
        for (Map.Entry<ResourceLocation, PlayerStateConnectionMap.ConnectionList> e : connectionMap.connections().entrySet()) {
            stb.append("\n  ").append(e.getKey());
            for (PlayerStateConnectionMap.Branch branch : e.getValue().branches()) {
                stb.append("\n    -> ").append(branch.state());
            }
            if (e.getValue().fallback() != null) {
                stb.append("\n    fallback: ").append(e.getValue().fallback());
            }
            stb.append('\n');
        }
        ParagliderMod.LOGGER.debug(stb.toString());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canBreatheUnderwater(@NotNull Player player) {
        return ParagliderUtilsImpl.canBreatheUnderwater(player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasTag(@NotNull Block block, @NotNull TagKey<Block> tagKey) {
        void var1_1;
        return ParagliderUtilsImpl.hasTag(block, (TagKey<Block>)var1_1);
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static Item getItem(@NotNull ResourceLocation id) {
        return ParagliderUtilsImpl.getItem(id);
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static ResourceLocation getKey(@NotNull Item item) {
        return ParagliderUtilsImpl.getKey(item);
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static Block getBlock(@NotNull ResourceLocation id) {
        return ParagliderUtilsImpl.getBlock(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void forRemainingItem(@NotNull ItemStack stack, @NotNull @NotNull Consumer<@NotNull ItemStack> forRemainingItem) {
        void var1_1;
        ParagliderUtilsImpl.forRemainingItem(stack, (Consumer<ItemStack>)var1_1);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static InputConstants.Key getKey(@NotNull KeyMapping keyMapping) {
        return ParagliderUtilsImpl.getKey(keyMapping);
    }

    /*
     * WARNING - void declaration
     */
    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isActiveAndMatches(@NotNull KeyMapping keyMapping, @NotNull InputConstants.Key key) {
        void var1_1;
        return ParagliderUtilsImpl.isActiveAndMatches(keyMapping, (InputConstants.Key)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isClient() {
        return ParagliderUtilsImpl.isClient();
    }

    private static final class ClientImpl {
        private ClientImpl() {
        }

        @NotNull
        static PlayerMovement createPlayerMovement(@NotNull Player player) {
            RemotePlayerMovement remotePlayerMovement;
            if (player instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)player;
                remotePlayerMovement = new ClientPlayerMovement(localPlayer);
            } else {
                remotePlayerMovement = new RemotePlayerMovement(player);
            }
            return remotePlayerMovement;
        }
    }
}

