/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.MovementPlugin;
import tictim.paraglider.api.movement.MovementPluginAction;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerStateCondition;
import tictim.paraglider.api.plugin.PluginAction;
import tictim.paraglider.api.plugin.PluginInstance;
import tictim.paraglider.impl.movement.PlayerStateConnectionMap;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.movement.SimplePlayerState;
import tictim.paraglider.plugin.ParagliderPluginLoader;
import tictim.paraglider.plugin.ParagliderPluginUtils;

public final class PlayerStateMapLoader {
    private PlayerStateMapLoader() {
    }

    @NotNull
    public static Pair<PlayerStateMap, PlayerStateConnectionMap> loadStates() {
        return PlayerStateMapLoader.loadStates(ParagliderPluginLoader.get().getMovementPlugins(), true);
    }

    @NotNull
    public static Pair<PlayerStateMap, PlayerStateConnectionMap> loadStates(@NotNull @NotNull List<@NotNull PluginInstance<MovementPlugin>> plugins, boolean insertIdleIfMissing) {
        Map<ResourceLocation, State> states = PlayerStateMapLoader.gatherStates(plugins);
        if (insertIdleIfMissing && !states.containsKey(ParagliderPlayerStates.IDLE)) {
            ParagliderMod.LOGGER.error("None of the plugins registered state " + ParagliderPlayerStates.IDLE + ", this is a bug!");
            State idle = new State(ParagliderPlayerStates.IDLE, false);
            idle.defaultStaminaDelta = 20;
            states.put(ParagliderPlayerStates.IDLE, idle);
        }
        PlayerStateMapLoader.gatherStateModifications(plugins, states);
        PlayerStateMapLoader.gatherStateConnections(plugins, states);
        ObjectOpenHashSet issues = new ObjectOpenHashSet();
        for (State state : states.values()) {
            List<State> circularLoop;
            if (state.synthetic && state.fallbackBranch == null) {
                issues.add("Fallback branch of the state " + state.id + " should be set");
            }
            if ((circularLoop = state.checkCircularLoop(states)) == null) continue;
            issues.add("Circular loop on fallback branches detected: " + circularLoop.stream().map(s -> s.id.toString()).collect(Collectors.joining(" -> ")));
        }
        if (!issues.isEmpty()) {
            throw new RuntimeException("Cannot continue loading paraglider plugins due to " + (String)(issues.size() == 1 ? "an issue" : issues.size() + " issues") + ":\n  " + String.join((CharSequence)"\n  ", (Iterable<? extends CharSequence>)issues));
        }
        return Pair.of((Object)new PlayerStateMap((Map)states.values().stream().collect(Collectors.toMap(s -> s.id, s -> new SimplePlayerState(s.id, s.flags, s.defaultStaminaDelta, s.defaultStaminaDelta < 0 ? 10 : 0), (s1, s2) -> s1, Object2ObjectOpenHashMap::new))), (Object)new PlayerStateConnectionMap((Map)states.values().stream().filter(s -> !s.branches.isEmpty() || s.fallbackBranch != null).collect(Collectors.toMap(s -> s.id, s -> new PlayerStateConnectionMap.ConnectionList(s.branches, s.fallbackBranch), (s1, s2) -> s1, Object2ObjectOpenHashMap::new))));
    }

    @NotNull
    private static Map<ResourceLocation, State> gatherStates(List<PluginInstance<MovementPlugin>> plugins) {
        ArrayList newStates = new ArrayList();
        Object2IntArrayMap idToCountMap = new Object2IntArrayMap();
        for (PluginInstance<MovementPlugin> plugin : plugins) {
            plugin.instance().registerNewStates(new MovementPlugin.PlayerStateRegister(){
                final /* synthetic */ Object2IntMap val$idToCountMap;
                final /* synthetic */ List val$newStates;
                final /* synthetic */ PluginInstance val$plugin;
                {
                    this.val$idToCountMap = object2IntMap;
                    this.val$newStates = list;
                    this.val$plugin = pluginInstance;
                }

                @Override
                public void register(@NotNull ResourceLocation id, int defaultStaminaDelta, ResourceLocation ... flags) {
                    Objects.requireNonNull(id, "id == null");
                    Objects.requireNonNull(flags, "flags == null");
                    for (ResourceLocation flag : flags) {
                        Objects.requireNonNull(flag);
                    }
                    this.val$idToCountMap.put((Object)id, this.val$idToCountMap.getInt((Object)id) + 1);
                    this.val$newStates.add(new PluginAction(this.val$plugin, new MovementPluginAction.NewState.Regular(id, defaultStaminaDelta, Set.of(flags))));
                }

                @Override
                public void registerSyntheticState(@NotNull ResourceLocation id) {
                    Objects.requireNonNull(id, "id == null");
                    this.val$idToCountMap.put((Object)id, this.val$idToCountMap.getInt((Object)id) + 1);
                    this.val$newStates.add(new PluginAction(this.val$plugin, new MovementPluginAction.NewState.Synthetic(id)));
                }
            });
        }
        for (Object2IntMap.Entry e : idToCountMap.object2IntEntrySet()) {
            if (e.getIntValue() < 2) continue;
            List list = ParagliderPluginUtils.removeAll(newStates, pa -> ((MovementPluginAction.NewState)pa.action()).id().equals(e.getKey()));
            List resolved = ParagliderPluginUtils.resolve(MovementPlugin::getMovementPluginConflictResolver, list);
            if (resolved == null || resolved.size() >= 2) {
                throw ParagliderPluginUtils.composePluginLoadingError(list);
            }
            if (resolved.size() != 1) continue;
            newStates.add(resolved.get(0));
        }
        Object2ObjectOpenHashMap states = new Object2ObjectOpenHashMap();
        for (PluginAction pluginAction : newStates) {
            states.put(((MovementPluginAction.NewState)pluginAction.action()).id(), new State((MovementPluginAction.NewState)pluginAction.action()));
        }
        return states;
    }

    private static void gatherStateModifications(List<PluginInstance<MovementPlugin>> plugins, final Map<ResourceLocation, State> states) {
        final ArrayList staminaDeltaChanges = new ArrayList();
        Object2IntArrayMap idToCountMap = new Object2IntArrayMap();
        Object2ObjectOpenHashMap flagAdditions = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap flagRemovals = new Object2ObjectOpenHashMap();
        for (final PluginInstance<MovementPlugin> pluginInstance : plugins) {
            pluginInstance.instance().modifyRegisteredStates(new MovementPlugin.PlayerStateModifier(){
                final /* synthetic */ Object2IntMap val$idToCountMap;
                final /* synthetic */ Map val$flagAdditions;
                final /* synthetic */ Map val$flagRemovals;
                {
                    this.val$idToCountMap = object2IntMap;
                    this.val$flagAdditions = map2;
                    this.val$flagRemovals = map3;
                }

                @Override
                public boolean exists(@NotNull ResourceLocation id) {
                    return states.containsKey(Objects.requireNonNull(id, "id == null"));
                }

                @Override
                public void changeDefaultStaminaDelta(@NotNull ResourceLocation id, int defaultStaminaDelta) {
                    Objects.requireNonNull(id, "id == null");
                    State state = (State)states.get(id);
                    if (state == null) {
                        throw new NoSuchElementException("No state with ID " + id + " exists");
                    }
                    if (state.synthetic) {
                        throw new IllegalStateException("Cannot change stamina delta of synthetic state " + id);
                    }
                    staminaDeltaChanges.add(new PluginAction(pluginInstance, new MovementPluginAction.ChangeDefaultStaminaDelta(id, defaultStaminaDelta)));
                    this.val$idToCountMap.put((Object)id, this.val$idToCountMap.getInt((Object)id) + 1);
                }

                @Override
                public void addFlags(@NotNull ResourceLocation id, ResourceLocation ... flags) {
                    Objects.requireNonNull(id, "id == null");
                    Objects.requireNonNull(flags, "flags == null");
                    State state = (State)states.get(id);
                    if (state == null) {
                        throw new NoSuchElementException("No state with ID " + id + " exists");
                    }
                    if (state.synthetic) {
                        throw new IllegalStateException("Cannot change flags of synthetic state " + id);
                    }
                    Set set = this.val$flagAdditions.computeIfAbsent(id, $ -> new ObjectOpenHashSet());
                    for (ResourceLocation flag : flags) {
                        set.add(Objects.requireNonNull(flag));
                    }
                }

                @Override
                public void removeFlags(@NotNull ResourceLocation id, ResourceLocation ... flags) {
                    Objects.requireNonNull(id, "id == null");
                    Objects.requireNonNull(flags, "flags == null");
                    State state = (State)states.get(id);
                    if (state == null) {
                        throw new NoSuchElementException("No state with ID " + id + " exists");
                    }
                    if (state.synthetic) {
                        throw new IllegalStateException("Cannot change flags of synthetic state " + id);
                    }
                    Set set = this.val$flagRemovals.computeIfAbsent(id, $ -> new ObjectOpenHashSet());
                    for (ResourceLocation flag : flags) {
                        set.add(Objects.requireNonNull(flag));
                    }
                }
            });
        }
        block5: for (Object2IntMap.Entry entry : idToCountMap.object2IntEntrySet()) {
            List list;
            if (entry.getIntValue() < 2 || (list = ParagliderPluginUtils.removeAll(staminaDeltaChanges, pa -> ((MovementPluginAction.ChangeDefaultStaminaDelta)pa.action()).id().equals(entry.getKey()))).isEmpty()) continue;
            int delta = ((MovementPluginAction.ChangeDefaultStaminaDelta)list.get(0).action()).defaultStaminaDelta();
            boolean same = true;
            for (int i = 1; i < list.size(); ++i) {
                if (((MovementPluginAction.ChangeDefaultStaminaDelta)list.get(i).action()).defaultStaminaDelta() == delta) continue;
                same = false;
                break;
            }
            if (same) continue;
            List resolved = ParagliderPluginUtils.resolve(MovementPlugin::getMovementPluginConflictResolver, list);
            if (resolved == null) {
                throw ParagliderPluginUtils.composePluginLoadingError(list);
            }
            switch (resolved.size()) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    staminaDeltaChanges.add(resolved.get(0));
                    continue block5;
                }
            }
            delta = ((MovementPluginAction.ChangeDefaultStaminaDelta)list.get(0).action()).defaultStaminaDelta();
            same = true;
            for (int i = 1; i < list.size(); ++i) {
                if (((MovementPluginAction.ChangeDefaultStaminaDelta)list.get(i).action()).defaultStaminaDelta() == delta) continue;
                same = false;
                break;
            }
            if (same) {
                staminaDeltaChanges.add(resolved.get(0));
                continue;
            }
            throw ParagliderPluginUtils.composePluginLoadingError(list);
        }
        for (PluginAction pluginAction : staminaDeltaChanges) {
            states.get((Object)((MovementPluginAction.ChangeDefaultStaminaDelta)pluginAction.action()).id()).defaultStaminaDelta = ((MovementPluginAction.ChangeDefaultStaminaDelta)pluginAction.action()).defaultStaminaDelta();
        }
        for (Map.Entry entry : flagRemovals.entrySet()) {
            states.get(entry.getKey()).flags.removeAll((Collection)entry.getValue());
        }
        for (Map.Entry entry : flagAdditions.entrySet()) {
            states.get(entry.getKey()).flags.addAll((Collection)entry.getValue());
        }
    }

    private static void gatherStateConnections(List<PluginInstance<MovementPlugin>> plugins, final Map<ResourceLocation, State> states) {
        Object2ObjectLinkedOpenHashMap fallbackBranches = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap branchAdditions = new Object2ObjectLinkedOpenHashMap();
        Object2ObjectLinkedOpenHashMap branchRemovals = new Object2ObjectLinkedOpenHashMap();
        for (PluginInstance<MovementPlugin> pluginInstance : plugins) {
            pluginInstance.instance().registerStateConnections(new MovementPlugin.PlayerStateConnectionRegister(){
                final /* synthetic */ Map val$branchAdditions;
                final /* synthetic */ Map val$branchRemovals;
                final /* synthetic */ Map val$fallbackBranches;
                final /* synthetic */ PluginInstance val$plugin;
                {
                    this.val$branchAdditions = map2;
                    this.val$branchRemovals = map3;
                    this.val$fallbackBranches = map4;
                    this.val$plugin = pluginInstance;
                }

                @Override
                public boolean exists(@NotNull ResourceLocation id) {
                    return states.containsKey(Objects.requireNonNull(id, "id == null"));
                }

                @Override
                public void addBranch(@NotNull ResourceLocation parent, @NotNull PlayerStateCondition condition, @NotNull ResourceLocation state, double priority) {
                    Objects.requireNonNull(condition, "condition == null");
                    if (!states.containsKey(Objects.requireNonNull(parent, "parent == null"))) {
                        throw new NoSuchElementException("No state with ID " + parent + " exists");
                    }
                    if (!states.containsKey(Objects.requireNonNull(state, "state == null"))) {
                        throw new NoSuchElementException("No state with ID " + state + " exists");
                    }
                    if (parent.equals((Object)state)) {
                        return;
                    }
                    record AddBranch(@NotNull PlayerStateCondition condition, @NotNull ResourceLocation state, double priority) {
                    }
                    this.val$branchAdditions.computeIfAbsent(parent, $ -> new ArrayList()).add(new AddBranch(condition, state, priority));
                }

                @Override
                public void removeBranch(@NotNull ResourceLocation parent, @NotNull ResourceLocation state, @Nullable Double priority) {
                    if (!states.containsKey(Objects.requireNonNull(parent, "parent == null"))) {
                        throw new NoSuchElementException("No state with ID " + parent + " exists");
                    }
                    if (!states.containsKey(Objects.requireNonNull(state, "state == null"))) {
                        throw new NoSuchElementException("No state with ID " + state + " exists");
                    }
                    if (parent.equals((Object)state)) {
                        return;
                    }
                    record RemoveBranch(@NotNull ResourceLocation state, @Nullable Double priority) {
                    }
                    this.val$branchRemovals.computeIfAbsent(parent, $ -> new ArrayList()).add(new RemoveBranch(state, priority));
                }

                @Override
                public void setFallback(@NotNull ResourceLocation parent, @Nullable ResourceLocation fallback, double priority) {
                    if (!states.containsKey(Objects.requireNonNull(parent, "parent == null"))) {
                        throw new NoSuchElementException("No state with ID " + parent + " exists");
                    }
                    if (fallback != null && !states.containsKey(fallback)) {
                        throw new NoSuchElementException("No state with ID " + fallback + " exists");
                    }
                    if (parent.equals((Object)fallback)) {
                        throw new IllegalArgumentException("Trying to set itself as fallback state");
                    }
                    List branchList = this.val$fallbackBranches.computeIfAbsent(parent, $ -> new ArrayList());
                    if (!branchList.isEmpty()) {
                        double p = ((MovementPluginAction.SetFallbackBranch)((PluginAction)branchList.get(0)).action()).priority();
                        if (p > priority) {
                            return;
                        }
                        if (p < priority) {
                            branchList.clear();
                        }
                    }
                    branchList.add(new PluginAction(this.val$plugin, new MovementPluginAction.SetFallbackBranch(parent, fallback, priority)));
                }
            });
        }
        block5: for (Map.Entry entry : fallbackBranches.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() <= 1) continue;
            @Nullable ResourceLocation fallback = ((MovementPluginAction.SetFallbackBranch)((PluginAction)list.get(0)).action()).fallback();
            boolean same = true;
            for (int i = 1; i < list.size(); ++i) {
                if (Objects.equals(((MovementPluginAction.SetFallbackBranch)((PluginAction)list.get(i)).action()).fallback(), fallback)) continue;
                same = false;
                break;
            }
            if (same) continue;
            List resolved = ParagliderPluginUtils.resolve(MovementPlugin::getMovementPluginConflictResolver, list);
            if (resolved == null) {
                throw ParagliderPluginUtils.composePluginLoadingError(list);
            }
            switch (resolved.size()) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    list.clear();
                    list.add(resolved.get(0));
                    continue block5;
                }
            }
            fallback = ((MovementPluginAction.SetFallbackBranch)((PluginAction)list.get(0)).action()).fallback();
            same = true;
            for (int i = 1; i < list.size(); ++i) {
                if (Objects.equals(((MovementPluginAction.SetFallbackBranch)((PluginAction)list.get(i)).action()).fallback(), fallback)) continue;
                same = false;
                break;
            }
            if (same) {
                list.clear();
                list.add(resolved.get(0));
                continue;
            }
            throw ParagliderPluginUtils.composePluginLoadingError(list);
        }
        for (Map.Entry entry : branchAdditions.entrySet()) {
            @Nullable List removals = (List)branchRemovals.get(entry.getKey());
            List list = (List)entry.getValue();
            if (removals != null) {
                list.removeIf(b -> {
                    for (RemoveBranch r : removals) {
                        if (!r.state.equals((Object)b.state) || r.priority != null && r.priority != b.priority) continue;
                        return true;
                    }
                    return false;
                });
            }
            list.sort(Comparator.comparingDouble(AddBranch::priority).reversed());
            State state = states.get(entry.getKey());
            for (AddBranch b2 : list) {
                state.branches.add(new PlayerStateConnectionMap.Branch(b2.condition, b2.state));
            }
        }
        for (Map.Entry entry : fallbackBranches.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            states.get(entry.getKey()).fallbackBranch = ((MovementPluginAction.SetFallbackBranch)((PluginAction)((List)entry.getValue()).get(0)).action()).fallback();
        }
    }

    private static final class State {
        @NotNull
        final ResourceLocation id;
        int defaultStaminaDelta;
        @NotNull
        final @NotNull Set<@NotNull ResourceLocation> flags = new ObjectOpenHashSet();
        final boolean synthetic;
        @NotNull
        final @NotNull List<@NotNull PlayerStateConnectionMap.Branch> branches = new ArrayList<PlayerStateConnectionMap.Branch>();
        @Nullable
        ResourceLocation fallbackBranch;
        @NotNull
        CheckStatus circularLoopCheckStatus = CheckStatus.UNCHECKED;

        State(@NotNull MovementPluginAction.NewState newState) {
            this.id = newState.id();
            if (newState instanceof MovementPluginAction.NewState.Regular) {
                MovementPluginAction.NewState.Regular regular = (MovementPluginAction.NewState.Regular)newState;
                this.defaultStaminaDelta = regular.defaultStaminaDelta();
                this.flags.addAll(regular.flags());
                this.synthetic = false;
            } else {
                this.synthetic = true;
            }
        }

        State(@NotNull ResourceLocation id, boolean synthetic) {
            this.id = id;
            this.synthetic = synthetic;
        }

        @Nullable
        List<State> checkCircularLoop(@NotNull Map<ResourceLocation, State> states) {
            return switch (this.circularLoopCheckStatus) {
                default -> throw new IncompatibleClassChangeError();
                case CheckStatus.UNCHECKED -> {
                    if (this.fallbackBranch == null) {
                        this.circularLoopCheckStatus = CheckStatus.CHECKED;
                        yield null;
                    }
                    this.circularLoopCheckStatus = CheckStatus.CHECKING;
                    List<State> circularLoop = states.get(this.fallbackBranch).checkCircularLoop(states);
                    if (circularLoop != null && (circularLoop.size() <= 1 || circularLoop.get(circularLoop.size() - 1) != circularLoop.get(0))) {
                        circularLoop.add(this);
                    }
                    this.circularLoopCheckStatus = CheckStatus.CHECKED;
                    yield circularLoop;
                }
                case CheckStatus.CHECKING -> {
                    this.circularLoopCheckStatus = CheckStatus.CHECKED;
                    ArrayList<State> list = new ArrayList<State>();
                    list.add(this);
                    yield list;
                }
                case CheckStatus.CHECKED -> null;
            };
        }

        static enum CheckStatus {
            UNCHECKED,
            CHECKING,
            CHECKED;

        }
    }
}

