/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerStateMap;
import tictim.paraglider.impl.vessel.NullVesselContainer;
import tictim.paraglider.network.SyncMovementHandle;

public class RemotePlayerMovement
extends PlayerMovement
implements SyncMovementHandle {
    public RemotePlayerMovement(@NotNull Player player) {
        super(player);
    }

    @Override
    @NotNull
    protected Stamina createStamina() {
        return ParagliderAPI.staminaFactory().createRemoteInstance(this.player());
    }

    @Override
    @NotNull
    protected VesselContainer createVesselContainer() {
        return NullVesselContainer.get();
    }

    @Override
    public void update() {
    }

    @Override
    public void syncMovement(@NotNull ResourceLocation stateId, int stamina, boolean depleted, int recoveryDelay) {
        PlayerStateMap stateMap = ParagliderMod.instance().getPlayerStateMap();
        PlayerState state = stateMap.getState(stateId);
        this.setState(state == null ? stateMap.getIdleState() : state);
        this.stamina().setStamina(stamina);
        this.stamina().setDepleted(depleted);
        this.setRecoveryDelay(recoveryDelay);
    }
}

