/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class MovingElevatorsMixinPlugin
implements IMixinConfigPlugin {
    private boolean isSodiumLoaded;
    private boolean isIrisLoaded;

    public void onLoad(String mixinPackage) {
        this.isSodiumLoaded = MovingElevatorsMixinPlugin.isClassAvailable("me.jellysquid.mods.sodium.client.SodiumClientMod");
        this.isIrisLoaded = MovingElevatorsMixinPlugin.isClassAvailable("net.coderbot.iris.Iris");
    }

    private static boolean isClassAvailable(String location) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(location);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return !this.isSodiumLoaded || !mixinClassName.endsWith(".LevelRendererMixin");
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        if (this.isSodiumLoaded) {
            mixins.addAll(Lists.newArrayList((Object[])new String[]{"sodium.LevelRendererMixinSodium", "sodium.SodiumWorldRendererMixin"}));
        }
        if (this.isIrisLoaded) {
            mixins.add("iris.ShadowRendererMixin");
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

