/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.common.block;

import com.illusivesoulworks.culinaryconstruct.api.CulinaryConstructApi;
import com.illusivesoulworks.culinaryconstruct.api.ICulinaryIngredient;
import com.illusivesoulworks.culinaryconstruct.common.block.CulinaryStationMenu;
import com.illusivesoulworks.culinaryconstruct.common.config.CulinaryConstructConfig;
import com.illusivesoulworks.culinaryconstruct.common.item.CulinaryItemBase;
import com.illusivesoulworks.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import com.illusivesoulworks.culinaryconstruct.common.util.CulinaryTags;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CulinaryStationBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{6};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1, 2, 3, 4, 5};
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);

    public CulinaryStationBlockEntity(BlockPos pos, BlockState state) {
        super(CulinaryConstructRegistry.CULINARY_STATION_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int index, @Nonnull ItemStack stack, @Nullable Direction side) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, @Nonnull ItemStack stack, @Nonnull Direction side) {
        return false;
    }

    public boolean m_7013_(int index, @Nonnull ItemStack stack) {
        if (index == 6) {
            return false;
        }
        if (index == 0) {
            return CulinaryTags.isBowl(stack) || CulinaryTags.isBread(stack);
        }
        Optional<ICulinaryIngredient> culinary = CulinaryConstructApi.getCulinaryIngredient(stack);
        return !(stack.m_41720_() instanceof CulinaryItemBase) && (stack.m_41720_().m_41472_() || culinary.map(ICulinaryIngredient::isValid).orElse(false) != false) && CulinaryConstructConfig.isValidIngredient(stack);
    }

    @Nonnull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.culinaryconstruct.culinary_station");
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int index, @Nonnull Inventory inv) {
        return new CulinaryStationMenu(index, inv, (Container)this);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!flag) {
            this.m_6596_();
        }
    }

    public boolean m_6542_(@Nonnull Player player) {
        if (this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_5809_(@Nonnull StackedContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.m_36491_(itemstack);
        }
    }
}

