/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class WaystoneJigsawPiece
extends LegacySinglePoolElement {
    private static Set<BlockPos> generatedPieces;
    public static final Codec<WaystoneJigsawPiece> codec;

    public static void reset() {
        generatedPieces = new HashSet<BlockPos>();
    }

    public WaystoneJigsawPiece(ResourceLocation location, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour) {
        this((Either<ResourceLocation, StructureTemplate>)Either.left((Object)location), structureProcessorListSupplier, placementBehaviour);
    }

    public WaystoneJigsawPiece(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour) {
        super(template, structureProcessorListSupplier, placementBehaviour);
    }

    public boolean m_213695_(StructureTemplateManager templateManager, WorldGenLevel seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos pieceLocation, BlockPos villageLocation, Rotation rotation, BoundingBox boundingBox, RandomSource random, boolean shouldUseJigsawReplacementStructureProcessor) {
        if (!Config.Server.worldGen.isVillageGenerationEnabled()) {
            return false;
        }
        if (generatedPieces.contains(villageLocation) || VillageWaystone.doesWaystoneExistIn(villageLocation)) {
            return false;
        }
        StructurePlaceSettings placementSettings = this.m_207169_(rotation, boundingBox, shouldUseJigsawReplacementStructureProcessor);
        StructureTemplate template = (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureTemplateManager)templateManager).m_230359_(arg_0), Function.identity());
        if (template.m_230328_((ServerLevelAccessor)seedReader, pieceLocation, villageLocation, placementSettings, random, 18)) {
            generatedPieces.add(villageLocation);
            return true;
        }
        return false;
    }

    @NotNull
    public StructurePoolElementType<?> m_207234_() {
        return JigsawDeserializers.waystone;
    }

    @NotNull
    public String toString() {
        return "SingleSignpostWaystone[" + this.f_210411_ + "]";
    }

    static {
        codec = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)WaystoneJigsawPiece.m_210465_(), (App)WaystoneJigsawPiece.m_210462_(), (App)WaystoneJigsawPiece.m_210538_()).apply((Applicative)codecBuilder, WaystoneJigsawPiece::new));
    }
}

